<?php
// Enqueue the parent theme's stylesheet

function hello_elementor_child_enqueue_styles()
{
    wp_enqueue_style('hello-elementor-parent-style', get_template_directory_uri() . '/../hello-elementor-child/style.css');
}
add_action('wp_enqueue_scripts', 'hello_elementor_child_enqueue_styles');




// custom code
// Enqueue Booststrap 
function enqueue_bootstrap()
{
    wp_enqueue_style('bootstrap-css', 'https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css');
    wp_enqueue_script('bootstrap-js', 'https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.min.js', array('jquery'), null, true);
}
add_action('wp_enqueue_scripts', 'enqueue_bootstrap');
add_action('wp_enqueue_scripts', 'enqueue_bootstrap');

//  Slick carousel script and styles
function enqueue_slick_scripts()
{
    //  Slick carousel script
    wp_enqueue_script('slick-js', 'https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.9.0/slick.min.js', array('jquery'), null, true);
    //  Slick carousel CSS
    wp_enqueue_style('slick-css', 'https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.9.0/slick.min.css');
}
add_action('wp_enqueue_scripts', 'enqueue_slick_scripts');



// custom code






// Home slider Start --------------------------------------------
function display_banner_home($atts)
{
    $args = array(
        'post_type' => 'main-slider',
    );

    $mainslider_query = new WP_Query($args);

    ob_start();

    if ($mainslider_query->have_posts()):
        $total_slides = $mainslider_query->post_count;
        $slide_num = 1;
        ?>
        <div id="demo" class="carousel slide hero-banner" data-bs-ride="carousel">
            <div class="carousel-inner">
                <?php
                $first = true;
                $slide_index = 0;
                while ($mainslider_query->have_posts()):
                    $mainslider_query->the_post(); ?>

                    <div class="carousel-item <?php echo $first ? 'active' : ''; ?>">

                        <?php
                        $featured_video = get_field('featured_video');
                        ?>
                        <?php
                        if ($featured_video) {
                            $file_url = is_array($featured_video) ? $featured_video['url'] : $featured_video;
                            echo ' <video controls autoplay width="100%">
                                            <source src="' . esc_url($file_url) . '" type="video/mp4" class="video-box">
                                        </video>
                            ';
                        } elseif (has_post_thumbnail()) {
                            the_post_thumbnail('full', array('class' => 'd-block w-100'));
                        }
                        ?>

                        <?php ?>
                        <div class="carousel-caption">
                            <h5><?php the_title(); ?></h5>
                            <h2> <?php the_content(); ?> </h2>
                            <div class="btnlight">
                                <?php
                                $links = get_field('button_link');
                                if ($links) {
                                    $link_url = $links['url'];
                                    $link_title = $links['title'];
                                    ?>
                                    <a href="<?php echo esc_url($link_url); ?>"
                                        class="elementor-button"><?php echo esc_html($link_title); ?></a>
                                <?php } ?>
                            </div>
                        </div>
                    </div>
                    <?php
                    $first = false;
                    $slide_index++;
                endwhile; ?>
            </div>


            <?php if ($total_slides > 1): ?>
                <div class="indicators-num">
                    <div class="carousel-indicator">
                        <?php for ($i = 0; $i < $total_slides; $i++): ?>
                            <div class="numbtn">
                                <button type="button" data-bs-target="#demo" data-bs-slide-to="<?php echo $i; ?>"
                                    class="<?php echo $i === 0 ? 'active' : ''; ?>">
                                </button>
                                <span> <?php //echo str_pad($i + 1, 2, '0', STR_PAD_LEFT); 
                                                ?></span>
                            </div>

                        <?php endfor; ?>
                        <p id="current-slide-number" class="mb-0"> <span id="current-slide"><?php echo $slide_num; ?></span> /
                            <?php echo $total_slides; ?>
                        </p>
                    </div>
                </div>

            <?php endif; ?>

            <script>
                document.addEventListener("DOMContentLoaded", function () {
                    var myCarousel = document.querySelector("#demo");
                    var currentSlideElement = document.querySelector("#current-slide");

                    myCarousel.addEventListener("slid.bs.carousel", function (event) {
                        var activeIndex = event.to + 1; // Carousel index starts from 0, so add 1
                        currentSlideElement.textContent = activeIndex;
                    });
                });
            </script>

        </div>

    <?php else: ?>
        <div>No Slider found.</div>
    <?php endif;

    wp_reset_postdata();

    return ob_get_clean();
}
add_shortcode('banner_home', 'display_banner_home');


// Home slider end --------------------------------------------

// Testimonial page start ------------------------------------------------------------

function display_testimonials($atts)
{
    // Attributes
    $atts = shortcode_atts(
        array(
            'posts_per_page' => 6,
        ),
        $atts,
        'testimonials'
    );

    // Get the current page
    $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;


    $args = array(
        'post_type' => 'testimonials',
        'posts_per_page' => $atts['posts_per_page'],
        'paged' => $paged,
    );

    $testimonials_query = new WP_Query($args);

    ob_start();

    if ($testimonials_query->have_posts()): ?>
        <div class="testimonial-page mt-3 testimonials-main">
            <div class="row g-md-3 g-3" id="testimonials-container">
                <?php while ($testimonials_query->have_posts()):
                    $testimonials_query->the_post();
                    ?>
                    <div class="col-md-4 col-sm-6">
                        <div class="testimonial-box h-100">
                            <div class="mb-0">
                                <p class="rating"><?php echo get_the_title(); ?></p>
                            </div>
                            <div class="testimonial-text ">
                                <?php echo the_content(); ?>
                            </div>
                            <div class="testimonial-heading d-flex align-items-center justify-content-start mb-2">
                                <div class="user-icon me-3">
                                    <?php if (has_post_thumbnail()) {
                                        the_post_thumbnail('full', array('class' => 'd-block w-100'));
                                    } ?>
                                </div>
                                <div class="user-detail">

                                    <?php
                                    $c_name = get_field('c_name');
                                    if ($c_name):
                                        echo '<p class="user-name">';
                                        echo $c_name;
                                        echo '</p>';
                                    endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endwhile; ?>
            </div>

            <div class="pagination-center text-center mt-md-5 mt-3 mb-3">
                <div class="pagination-two">
                    <?php
                    echo paginate_links(array(
                        'total' => $testimonials_query->max_num_pages,
                        'current' => $paged,
                        'format' => '?paged=%#%',
                        'add_args' => array('category' => $selected_category), // Retain category filter in pagination
                        'show_all' => false,
                        'type' => 'plain',
                        'prev_text' => __('<img src="https://draftsite1.com/thor-international/wp-content/uploads/2025/05/left-arrow.png">'),
                        'next_text' => __('<img src="https://draftsite1.com/thor-international/wp-content/uploads/2025/05/right-arrow.png">'),
                        'end_size' => 2,
                        'mid_size' => 2
                    ));
                    ?>
                </div>
            </div>


        </div>



    <?php else:
        echo 'No testimonials found.';
    endif;

    wp_reset_postdata();

    return ob_get_clean();
}
add_shortcode('testimonials', 'display_testimonials');


// Testimonial page end ------------------------------------------------------------


// testimonials slider start 
function display_testimonials_slider($atts)
{
    // Attributes
    $atts = shortcode_atts(
        array(
            'posts_per_page' => 6,
        ),
        $atts,
        'testimonials'
    );

    $args = array(
        'post_type' => 'testimonials',
        'posts_per_page' => $atts['posts_per_page'],
    );

    $testimonials_query = new WP_Query($args);

    ob_start();

    if ($testimonials_query->have_posts()): ?>
        <div class="testimonial-slider">
            <div class="slick-slider-testimonial pb-2">
                <?php while ($testimonials_query->have_posts()):
                    $testimonials_query->the_post();
                    ?>

                    <div class="item ps-2 pe-2">

                        <div class="testimonial-box h-100">
                            <div class="mb-0">
                                <p class="rating"><?php echo get_the_title(); ?> </p>
                            </div>
                            <div class="testimonial-text ">
                                <?php echo get_the_content(); ?>
                            </div>

                            <div class="testimonial-heading d-flex align-items-center justify-content-start mb-2">
                                <div class="user-icon me-3">
                                    <?php if (has_post_thumbnail()) {
                                        the_post_thumbnail('full', array('class' => 'd-block w-100'));
                                    } ?>
                                </div>
                                <div class="user-detail">
                                    <?php   
                                    $c_name = get_field('c_name');
                                    if ($c_name):
                                        echo '<p class="user-name">';
                                        echo $c_name;
                                        echo '</p>';
                                    endif; ?>
                                </div>
                            </div>
                        </div>

                    </div>
                <?php endwhile; ?>
            </div>
        </div>

        <script>
            jQuery(document).ready(function ($) {
                $(".slick-slider-testimonial").slick({
                    dots: true,
                    infinite: true,
                    speed: 300,
                    slidesToShow: 3,
                    slidesToScroll: 1,
                    adaptiveHeight: true,
                    prevArrow: "#tes-prev",
                    nextArrow: "#tes-next",
                    responsive: [{
                        breakpoint: 1200,
                        settings: {
                            slidesToShow: 2,
                            slidesToScroll: 1,
                        },
                    },
                    {
                        breakpoint: 1008,
                        settings: {
                            slidesToShow: 3,
                            slidesToScroll: 1,
                        },
                    },
                    {
                        breakpoint: 800,
                        settings: {
                            slidesToShow: 1,
                            slidesToScroll: 1,
                        },
                    },
                    ],
                });

            });
        </script>

    <?php else:
        echo 'No testimonials found.';
    endif;

    wp_reset_postdata();

    return ob_get_clean();
}
add_shortcode('testimonials_slider', 'display_testimonials_slider');
// testimonials slider end ------------------------------


// downloads page start ------------------------------------------------------------

function display_downloads($atts)
{
    // Attributes
    $atts = shortcode_atts(
        array(
            'posts_per_page' => 6,
        ),
        $atts,
        'downloads'
    );

    // Get the current page
    $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;


    $args = array(
        'post_type' => 'downloads',
        'posts_per_page' => $atts['posts_per_page'],
        'paged' => $paged,
    );

    $downloads_query = new WP_Query($args);

    ob_start();

    if ($downloads_query->have_posts()): ?>
        <div class="testimonial-page mt-3 downloads-main">
            <div class="row g-md-3 g-3" id="downloads-container">
                <?php while ($downloads_query->have_posts()):
                    $downloads_query->the_post();
                    ?>
                    <div class="col-lg-4 col-sm-6 mb-4">
                        <div class="download-box">
                            <div class="img-box mb-1">
                                <?php if (has_post_thumbnail()) {
                                    the_post_thumbnail('full', array('class' => 'd-block w-100'));
                                } ?>
                            </div>
                            <div class="text-box">
                                <h4 class="mb-1"><?php echo get_the_title(); ?></h4>
                                <div class="description">
                                    <?php echo the_content(); ?>
                                </div>

                                <?php $downloads_file = get_post_meta(get_the_ID(), 'downloads_file', true);
                                $downloads_file = get_field('downloads_file');
                                if ($downloads_file): ?>
                                    <a href="<?php echo esc_url($downloads_file); ?>" download class="elementor-button">Download File
                                        <img src="https://draftsite1.com/thor-international/wp-content/uploads/2025/04/PDF.svg"
                                            alt=""></a>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                <?php endwhile; ?>
            </div>

            <div class="pagination-center text-center mt-md-5 mt-3 mb-3">
                <div class="pagination-two">
                    <?php
                    echo paginate_links(array(
                        'total' => $downloads_query->max_num_pages,
                        'current' => $paged,
                        'format' => '?paged=%#%',
                        'add_args' => array('category' => $selected_category), // Retain category filter in pagination
                        'show_all' => false,
                        'type' => 'plain',
                        'prev_text' => __('<img src="https://draftsite1.com/thor-international/wp-content/uploads/2025/05/left-arrow.png">'),
                        'next_text' => __('<img src="https://draftsite1.com/thor-international/wp-content/uploads/2025/05/right-arrow.png">'),
                        'end_size' => 2,
                        'mid_size' => 2
                    ));
                    ?>
                </div>
            </div>


        </div>



    <?php else:
        echo 'No downloads found.';
    endif;

    wp_reset_postdata();

    return ob_get_clean();
}
add_shortcode('downloads', 'display_downloads');


// downloads page end ------------------------------------------------------------




// videos page start ------------------------------------------------------------

function display_videos($atts)
{
    // Attributes
    $atts = shortcode_atts(
        array(
            'posts_per_page' => 9,
        ),
        $atts,
        'videos'
    );

    // Get the current page
    $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;


    $args = array(
        'post_type' => 'videos',
        'posts_per_page' => $atts['posts_per_page'],
        'paged' => $paged,
    );

    $videos_query = new WP_Query($args);

    ob_start();

    if ($videos_query->have_posts()): ?>
        <div class="testimonial-page mt-3 videos-main">
            <div class="row g-md-3 g-3" id="videos-container">
                <?php while ($videos_query->have_posts()):
                    $videos_query->the_post();
                    ?>
                    <div class="col-lg-4 col-sm-6 mb-4">
                        <div class="video-box" data-bs-toggle="modal" data-bs-target="#videoModal<?php echo get_the_ID(); ?>">
                            <div class="img-box">

                                <?php
                                $videos = get_field('videos');
                                $youtube = get_field('youtube_embed_video');
                                ?>
                                <?php
                                if ($videos) {
                                    $file_url = is_array($videos) ? $videos['url'] : $videos;
                                    echo '
                                        <video controls width="100%">
                                            <source src="' . esc_url($file_url) . '" type="video/mp4" class="video-box">
                                        </video>
                                         <img src="https://draftsite1.com/thor-international/wp-content/uploads/2025/04/play-button-1.png"
                                    alt="" class="play-button">
                                    ';
                                } elseif ($youtube) {
                                    echo '<div class="video-embed">';
                                    echo wp_oembed_get($youtube);
                                    echo '</div>';
                                    echo ' <img src="https://draftsite1.com/thor-international/wp-content/uploads/2025/04/play-button-1.png"
                                    alt="" class="play-button">';
                                }
                                ?>
                            </div>
                        </div>
                    </div>
                <?php endwhile; ?>
            </div>


            <?php while ($videos_query->have_posts()):
                $videos_query->the_post(); ?>

                <div class="modal videomodal fade" id="videoModal<?php echo get_the_ID(); ?>">
                    <div class="modal-dialog modal-dialog-centered modal-lg">
                        <div class="modal-content rounded-0 border-0">
                            <!-- Modal body -->
                            <div class="modal-body">
                                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                               
                                <?php
                                $videos = get_field('videos');
                                $youtube = get_field('youtube_embed_video');
                                ?>
                                <?php
                                if ($videos) {
                                    $file_url = is_array($videos) ? $videos['url'] : $videos;
                                    echo '
                                        <video controls width="100%">
                                            <source src="' . esc_url($file_url) . '" type="video/mp4" class="video-box">
                                        </video>
                                    ';
                                } elseif ($youtube) {
                                    echo '<div class="video-embed">';
                                    echo wp_oembed_get($youtube);
                                    echo '</div>';
                                }
                                ?>

                            </div>
                        </div>
                    </div>
                </div>

            <?php endwhile; ?>



            <div class="pagination-center text-center mt-md-5 mt-3 mb-3">
                <div class="pagination-two">
                    <?php
                    echo paginate_links(array(
                        'total' => $videos_query->max_num_pages,
                        'current' => $paged,
                        'format' => '?paged=%#%',
                        'add_args' => array('category' => $selected_category), // Retain category filter in pagination
                        'show_all' => false,
                        'type' => 'plain',
                        'prev_text' => __('<img src="https://draftsite1.com/thor-international/wp-content/uploads/2025/05/left-arrow.png">'),
                        'next_text' => __('<img src="https://draftsite1.com/thor-international/wp-content/uploads/2025/05/right-arrow.png">'),
                        'end_size' => 2,
                        'mid_size' => 2
                    ));
                    ?>
                </div>
            </div>


        </div>



    <?php else:
        echo 'No videos found.';
    endif;

    wp_reset_postdata();

    return ob_get_clean();
}
add_shortcode('videos', 'display_videos');


// videos page end ------------------------------------------------------------


function Videoss()
{
    // Define your HTML content here
    $html_content = '		
       <div class="row">
        <div class="col-lg-4 col-sm-6">
            <div class="video-box">
                <div class="img-box mb-1" data-bs-toggle="modal" data-bs-target="#videoModal">
                    <img src="https://draftsite1.com/thor-international/wp-content/uploads/2025/04/Sample1-1.jpg" alt="" class="w-100">
                    <img src="https://draftsite1.com/thor-international/wp-content/uploads/2025/04/play-button-1.png" alt="" class="play-button">
                </div>               
            </div>
        </div>
       </div>

       <!-- The Modal -->
        <div class="modal fade" id="videoModal">
            <div class="modal-dialog modal-dialog-centered modal-lg">
                <div class="modal-content rounded-0 border-0">
                <!-- Modal body -->
                    <div class="modal-body">
                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                        <video width="100%" height="100%" controls>
                            <source src="movie.mp4" type="video/mp4">
                        </video>
                        <iframe width="100%" height="350" src="https://www.youtube.com/embed/jX6CKPkZOQo?si=lzSAVz5cRJ2YaM8P" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" referrerpolicy="strict-origin-when-cross-origin" allowfullscreen></iframe>
                    </div>        
                </div>
            </div>
        </div>
	';
    return $html_content;
}
add_shortcode('Videoss', 'Videoss');




// article page start -----------------

function display_article($atts)
{

    $atts = shortcode_atts(
        array(
            'posts_per_page' => 9,
        ),
        $atts,
        'article_list_view'
    );


    $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
    $selected_category = isset($_GET['category']) ? sanitize_text_field($_GET['category']) : '';

    // Query arguments
    $args = array(
        'post_type' => 'post',
        'posts_per_page' => $atts['posts_per_page'],
        'paged' => $paged,
    );


    if (!empty($selected_category)) {
        $args['category_name'] = $selected_category;
    }

    $article_query = new WP_Query($args);

    ob_start();


    if ($article_query->have_posts()):
        ?>
        <div class="our-article">
            <div class="row g-md-4 g-3">

                <?php while ($article_query->have_posts()):
                    $article_query->the_post(); ?>

                    <div class="col-lg-4 col-md-4 mb-4">
                        <a href="<?php the_permalink(); ?>" class="blog-box">
                            <div class="category-detail-img mb-3">
                                <?php if (has_post_thumbnail()) {
                                    the_post_thumbnail('full', array('class' => 'd-block w-100'));
                                } ?>
                            </div>
                            <div class="category-detail-box">
                                <p class="d-flex align-items-center">
                                    <span class="line"></span>
                                    <span class="mx-2">BLOG</span>
                                    <small class="date">• <?php echo get_the_date('M j, Y'); ?></small>
                                </p>
                                <h4 class="mb-2"><?php echo the_title(); ?></h4>
                                <div class="description">
                                    <?php echo get_the_excerpt(); ?>
                                </div>
                                <button>
                                    <span>Read More</span>
                                    <img src="https://draftsite1.com/thor-international/wp-content/uploads/2025/04/arrow.png"
                                        alt="">
                                </button>
                            </div>
                        </a>
                    </div>


                <?php endwhile; ?>


                <div class="pagination-center text-center mt-md-5 mt-3 mb-3">
                    <div class="pagination-two">
                        <?php
                        echo paginate_links(array(
                            'total' => $article_query->max_num_pages,
                            'current' => $paged,
                            'format' => '?paged=%#%',
                            'add_args' => array('category' => $selected_category), // Retain category filter in pagination
                            'show_all' => false,
                            'type' => 'plain',
                            'prev_text' => __('<img src="https://draftsite1.com/thor-international/wp-content/uploads/2025/05/left-arrow.png">'),
                            'next_text' => __('<img src="https://draftsite1.com/thor-international/wp-content/uploads/2025/05/right-arrow.png">'),
                            'end_size' => 2,
                            'mid_size' => 2
                        ));
                        ?>
                    </div>
                </div>

            </div>
        </div>
        </div>
    <?php else:
        echo 'No Article found.';
    endif;

    wp_reset_postdata();

    return ob_get_clean();
}
add_shortcode('article_list_view', 'display_article');

// article end ----------------------------------------



// technical information  page start -----------------

function display_technical($atts)
{

    $atts = shortcode_atts(
        array(
            'posts_per_page' => 6,
        ),
        $atts,
        'technical_list_view'
    );


    $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
    $selected_category = isset($_GET['category']) ? sanitize_text_field($_GET['category']) : '';

    // Query arguments
    $args = array(
        'post_type' => 'technical-informatio',
        'posts_per_page' => $atts['posts_per_page'],
        'paged' => $paged,
    );


    if (!empty($selected_category)) {
        $args['category_name'] = $selected_category;
    }

    $technical_query = new WP_Query($args);

    ob_start();


    if ($technical_query->have_posts()):
        ?>
        <div class="our-technical">
            <div class="row g-md-4 g-3">

                <?php while ($technical_query->have_posts()):
                    $technical_query->the_post(); ?>

                    <div class="col-lg-4 col-md-4 mb-4">
                        <a href="<?php the_permalink(); ?>" class="blog-box">
                            <div class="category-detail-img mb-3">
                                <?php if (has_post_thumbnail()) {
                                    the_post_thumbnail('full', array('class' => 'd-block w-100'));
                                } ?>
                            </div>
                            <div class="category-detail-box-one">
                                <h4 class="mb-2"><?php echo the_title(); ?></h4>
                                <div class="description">
                                    <?php echo get_the_excerpt(); ?>
                                </div>
                                <button>
                                    <span>Read More</span>
                                    <img src="https://draftsite1.com/thor-international/wp-content/uploads/2025/04/arrow.png"
                                        alt="">
                                </button>
                            </div>
                        </a>
                    </div>


                <?php endwhile; ?>


                <div class="pagination-center text-center mt-md-5 mt-3 mb-3">
                    <div class="pagination-two">
                        <?php
                        echo paginate_links(array(
                            'total' => $technical_query->max_num_pages,
                            'current' => $paged,
                            'format' => '?paged=%#%',
                            'add_args' => array('category' => $selected_category), // Retain category filter in pagination
                            'show_all' => false,
                            'type' => 'plain',
                            'prev_text' => __(' « '),
                            'next_text' => __(' »'),
                            'end_size' => 2,
                            'mid_size' => 2
                        ));
                        ?>
                    </div>
                </div>

            </div>
        </div>
        </div>
    <?php else:
        echo 'No technical found.';
    endif;

    wp_reset_postdata();

    return ob_get_clean();
}
add_shortcode('technical_list_view', 'display_technical');

// technical information  end ----------------------------------------





// Part Number  page start -----------------

function display_partnumber($atts)
{

    $atts = shortcode_atts(
        array(
            'posts_per_page' => 6,
        ),
        $atts,
        'partnumber_list_view'
    );


    $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
    $selected_category = isset($_GET['category']) ? sanitize_text_field($_GET['category']) : '';

    // Query arguments
    $args = array(
        'post_type' => 'part-number',
        'posts_per_page' => $atts['posts_per_page'],
        'paged' => $paged,
    );


    if (!empty($selected_category)) {
        $args['category_name'] = $selected_category;
    }

    $partnumber_query = new WP_Query($args);

    ob_start();


    if ($partnumber_query->have_posts()):
        ?>
        <div class="our-partnumber">
            <div class="row g-md-4 g-3">

                <?php while ($partnumber_query->have_posts()):
                    $partnumber_query->the_post(); ?>

                    <div class="col-lg-4 col-md-4 mb-4">
                        <a href="<?php the_permalink(); ?>" class="blog-box">
                            <div class="category-detail-img mb-3">
                                <?php if (has_post_thumbnail()) {
                                    the_post_thumbnail('full', array('class' => 'd-block w-100'));
                                } ?>
                            </div>
                            <div class="category-detail-box-one">
                                <h4 class="mb-2"><?php echo the_title(); ?></h4>
                                <div class="description">
                                    <?php echo get_the_excerpt(); ?>
                                </div>
                                <button>
                                    <span>Read More</span>
                                    <img src="https://draftsite1.com/thor-international/wp-content/uploads/2025/04/arrow.png"
                                        alt="">
                                </button>
                            </div>
                        </a>
                    </div>


                <?php endwhile; ?>


                <div class="pagination-center text-center mt-md-5 mt-3 mb-3">
                    <div class="pagination-two">
                        <?php
                        echo paginate_links(array(
                            'total' => $partnumber_query->max_num_pages,
                            'current' => $paged,
                            'format' => '?paged=%#%',
                            'add_args' => array('category' => $selected_category), // Retain category filter in pagination
                            'show_all' => false,
                            'type' => 'plain',
                            'prev_text' => __('<img src="https://draftsite1.com/thor-international/wp-content/uploads/2025/05/left-arrow.png">'),
                            'next_text' => __('<img src="https://draftsite1.com/thor-international/wp-content/uploads/2025/05/right-arrow.png">'),
                            'end_size' => 2,
                            'mid_size' => 2
                        ));
                        ?>
                    </div>
                </div>

            </div>
        </div>
        </div>
    <?php else:
        echo 'No partnumber found.';
    endif;

    wp_reset_postdata();

    return ob_get_clean();
}
add_shortcode('partnumber_list_view', 'display_partnumber');

// Part Number  end ----------------------------------------






// brands page start ------------------------------------------------------------

function display_brands($atts)
{
    // Attributes
    $atts = shortcode_atts(
        array(
            'posts_per_page' => 12,
            'category' => isset($_GET['category']) ? sanitize_text_field($_GET['category']) : '',
            'search' => isset($_GET['keyword']) ? sanitize_text_field($_GET['keyword']) : '',
        ),
        $atts,
        'brands'
    );

    $paged = get_query_var('paged') ? get_query_var('paged') : 1;

    // WP_Query args
    $args = array(
        'post_type' => 'brands',
        'posts_per_page' => $atts['posts_per_page'],
        'paged' => $paged,
        'search' => $atts['search']
    );

    // Filter by category
    if (!empty($atts['category'])) {
        $args['tax_query'] = array(
            array(
                'taxonomy' => 'brands-filters',
                'field' => 'slug',
                'terms' => $atts['category'],
            ),
        );
    }

    // Filter by search term
    if (!empty($atts['search'])) {
        $args['s'] = $atts['search'];
    }

    // Get categories
    $categories = get_terms(array(
        'taxonomy' => 'brands-filters',
        'hide_empty' => true,
    ));

    ob_start();

    if ($categories): ?>
        <div class="row">
            <div class="col-lg-8 col-md-8 col-sm-12 mb-4">
                <div class="brand-filter">
                    <p class="mb-2">Brand Filters</p>
                    <div class="filter-btns">
                        <a href="<?php echo esc_url(home_url('/brands')); ?>"
                            class="all-cat-head <?php echo empty($atts['category']) ? 'active' : ''; ?>"> # </a>
                        <?php foreach ($categories as $category):
                            $active_class = ($atts['category'] === $category->slug) ? 'active' : '';
                            ?>
                            <a href="<?php echo esc_url(add_query_arg('category', $category->slug, home_url('/brands'))); ?>"
                                class="<?php echo esc_attr($active_class); ?>">
                                <?php echo esc_html($category->name); ?>
                            </a>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>
            <div class="col-lg-4 col-md-4 col-sm-12 mb-4">
                <form method="get" action="<?php echo esc_url(home_url('/brands')); ?>" class="brans-search">

                    <div class="input-group mb-0">
                        <input type="text" name="keyword" value="<?php echo esc_attr($atts['search']); ?>" class="form-control"
                            placeholder="Search…" aria-label="Search" aria-describedby="basic-addon2">
                        <button type="submit" class="input-group-text border-0 bg-none" id="basic-addon2">
                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512">
                                <path
                                    d="M505 442.7L405.3 343c-4.5-4.5-10.6-7-17-7H372c27.6-35.3 44-79.7 44-128C416 93.1 322.9 0 208 0S0 93.1 0 208s93.1 208 208 208c48.3 0 92.7-16.4 128-44v16.3c0 6.4 2.5 12.5 7 17l99.7 99.7c9.4 9.4 24.6 9.4 33.9 0l28.3-28.3c9.4-9.4 9.4-24.6 .1-34zM208 336c-70.7 0-128-57.2-128-128 0-70.7 57.2-128 128-128 70.7 0 128 57.2 128 128 0 70.7-57.2 128-128 128z" />
                            </svg>
                        </button>
                    </div>
                </form>
            </div>
        </div>
    <?php endif;

    $brands_query = new WP_Query($args);

    if ($brands_query->have_posts()): ?>
        <div id="brands-results" class="brands_list-page brands-main">
            <div class="row g-md-4 g-3">
                <?php while ($brands_query->have_posts()):
                    $brands_query->the_post(); ?>
                    <div class="col-lg-3 col-md-4 col-sm-6 mb-4">
                        <div class="brand-box">
                            <div class="img-box mb-1">
                                <?php if (has_post_thumbnail()) {
                                    the_post_thumbnail('full', array('class' => 'd-block w-100'));
                                } ?>
                            </div>
                            <div class="text-box">
                                <h4 class="mb-2"><?php the_title(); ?></h4>
                                <div class="description"><?php the_content(); ?></div>
                            </div>
                        </div>
                    </div>
                <?php endwhile; ?>
            </div>
        </div>

        <div class="pagination-center text-center mt-md-5 mt-3 mb-3">
            <div class="pagination-two d-inline-block">
                <?php
                echo paginate_links(array(
                    'total' => $brands_query->max_num_pages,
                    'current' => max(1, $paged),
                    'format' => '?paged=%#%',
                    'add_args' => array_filter(array(
                        'category' => $atts['category'],
                        's' => $atts['search']
                    )),
                    'show_all' => false,
                    'type' => 'plain',
                    'prev_text' => __('<img src="https://draftsite1.com/thor-international/wp-content/uploads/2025/05/left-arrow.png">'),
                    'next_text' => __('<img src="https://draftsite1.com/thor-international/wp-content/uploads/2025/05/right-arrow.png">'),
                    'end_size' => 2,
                    'mid_size' => 2
                ));
                ?>
            </div>
        </div>

    <?php else:
        echo 'No brands found.';
    endif;

    ?>

    <script>
        document.addEventListener("DOMContentLoaded", function () {
            const form = document.querySelector("#brands-results");
            const inputs = form.querySelectorAll("input");

            inputs.forEach(input => {
                input.addEventListener("change", function () {
                    const params = new URLSearchParams(window.location.search);

                    inputs.forEach(el => {
                        if (el.value) {
                            params.set(el.name, el.value);
                        } else {
                            params.delete(el.name);
                        }
                    });

                    // Update URL and reload
                    window.history.replaceState({}, '', '?' + params.toString());
                    location.reload();
                });

                // Prevent enter key submission
                input.addEventListener("keypress", function (e) {
                    if (e.key === "Enter") {
                        e.preventDefault();
                    }
                });
            });
        });
    </script>


    <?php

    wp_reset_postdata();

    return ob_get_clean();
}
add_shortcode('brands_list', 'display_brands');



// brands page End ------------------------------------------------------------


// woocommerce start

// Wrap WooCommerce product image in a div start ----------
add_action('woocommerce_before_shop_loop_item_title', 'wrap_product_image_in_div', 5);
function wrap_product_image_in_div()
{
    echo '<div class="custom-image-wrapper">';
}
add_action('woocommerce_before_shop_loop_item_title', 'close_product_image_div', 15);
function close_product_image_div()
{
    echo '</div>';
}
// Wrap WooCommerce product image in a div end ----------


// product-categories start ----------------------------------------- 

function wpb_woocommerce_product_categories_accordion()
{
    // Get the current queried product category
    $queried_object = get_queried_object();
    $current_category_id = ($queried_object && isset($queried_object->term_id)) ? $queried_object->term_id : 0;

    // Get all parent categories of the current category
    $current_category_parents = [];
    if ($current_category_id) {
        $parent_categories = get_ancestors($current_category_id, 'product_cat');
        $current_category_parents = array_map('intval', $parent_categories);
    }

    // Recursive function to get subcategories with checkboxes
    function get_subcategories($parent_id, $level = 1, $current_category_id, $current_category_parents)
    {
        $args = array(
            'taxonomy' => 'product_cat',
            'orderby' => 'name',
            'order' => 'ASC',
            'parent' => $parent_id,
            'hide_empty' => false
        );
        $sub_categories = get_terms($args);

        if (!empty($sub_categories)) {
            echo '<ul class="list-unstyled ps-2">';
            foreach ($sub_categories as $sub_category) {
                $is_checked = ($sub_category->term_id == $current_category_id) ? 'checked' : '';
                $active_class = ($sub_category->term_id == $current_category_id) ? 'current-category' : '';

                echo '<li class="' . $active_class . '">';
                echo '<div class="in-menu">';
                echo '<input type="checkbox" class="category-checkbox me-2" data-category-id="' . $sub_category->term_id . '" ' . $is_checked . '> ';

                echo '<a href="' . get_term_link($sub_category) . '">  <span class="customcheck"></span>' . $sub_category->name . '</a>';
                echo '</div>';
                get_subcategories($sub_category->term_id, $level + 1, $current_category_id, $current_category_parents);
                echo '</li>';
            }
            echo '</ul>';
        }
    }

    // Get main product categories (parent categories)
    $args = array(
        'taxonomy' => 'product_cat',
        'orderby' => 'name',
        'order' => 'ASC',
        'parent' => 0,
        'hide_empty' => false
    );
    $product_categories = get_terms($args);

    if ($product_categories) {
        ob_start();
        ?>
        <div class="accordion" id="productCategoriesAccordion">

            <?php
            $shop_page_url = wc_get_page_permalink('shop');
            $is_shop_page = is_shop();
            ?>

            <!-- <div class="accordion-item">
                    <div class="accordion-header <?php //echo $is_shop_page ? 'current-category' : ''; 
                            ?>">
                        <label>
                            <a href="<?php // echo esc_url($shop_page_url); 
                                    ?>" class="main-category">
                                All Product
                            </a>
                        </label>
                    </div>
                </div> -->


            <?php
            $i = 0;
            foreach ($product_categories as $category) {
                $i++;

                // Check if the category has subcategories
                $sub_args = array(
                    'taxonomy' => 'product_cat',
                    'parent' => $category->term_id,
                    'hide_empty' => true
                );
                $sub_categories = get_terms($sub_args);
                $has_subcategories = !empty($sub_categories);

                // Determine if this category should be expanded
                $is_checked = ($category->term_id == $current_category_id) ? 'checked' : '';
                $active_class = ($category->term_id == $current_category_id || in_array($category->term_id, $current_category_parents)) ? 'current-category' : '';
                $show_collapse = ($category->term_id == $current_category_id || in_array($category->term_id, $current_category_parents)) ? 'show' : '';
                ?>
                <div class="accordion-item <?php echo $active_class; ?>">
                    <div class="accordion-header d-flex align-items-center" id="heading<?php echo $i; ?>">
                        <label for="cat<?php echo $category->term_id; ?>">
                            <input type="checkbox" class="category-checkbox me-2" id="cat<?php echo $category->term_id; ?>"
                                data-category-id="<?php echo $category->term_id; ?>" <?php echo $is_checked; ?>>

                            <a href="<?php echo get_term_link($category); ?>" class="main-category">
                                <span class="customcheck"></span>
                                <?php echo $category->name . ' <span class="count">(' . $category->count . ')</span>'; ?>
                            </a>
                        </label>

                        <?php if ($has_subcategories) { ?>
                            <button class="accordion-button ms-auto <?php echo ($show_collapse == '') ? 'collapsed' : ''; ?>"
                                type="button" data-bs-toggle="collapse" data-bs-target="#collapse<?php echo $i; ?>"
                                aria-expanded="<?php echo ($show_collapse) ? 'true' : 'false'; ?>"
                                aria-controls="collapse<?php echo $i; ?>" data-category-id="<?php echo $category->term_id; ?>">
                                <i class="fa fa-angle-down"></i>
                            </button>
                        <?php } ?>
                    </div>
                    <?php if ($has_subcategories) { ?>
                        <div id="collapse<?php echo $i; ?>" class="accordion-collapse collapse <?php echo $show_collapse; ?>"
                            aria-labelledby="heading<?php echo $i; ?>" data-bs-parent="#productCategoriesAccordion">
                            <div class="accordion-body ps-0 pe-0">
                                <?php get_subcategories($category->term_id, 1, $current_category_id, $current_category_parents); ?>
                            </div>
                        </div>
                    <?php } ?>
                </div>
                <?php
            }
            ?>
        </div>

        <script>
            document.addEventListener("DOMContentLoaded", function () {
                var savedCategories = JSON.parse(localStorage.getItem("checkedCategories")) || [];

                savedCategories.forEach(function (categoryId) {
                    var checkbox = document.querySelector('.category-checkbox[data-category-id="' + categoryId + '"]');
                    if (checkbox) {
                        checkbox.checked = true;
                    }
                });

                document.querySelectorAll(".category-checkbox").forEach(function (checkbox) {
                    checkbox.addEventListener("change", function () {
                        var categoryId = this.getAttribute("data-category-id");
                        if (this.checked) {
                            if (!savedCategories.includes(categoryId)) {
                                savedCategories.push(categoryId);
                            }
                        } else {
                            savedCategories = savedCategories.filter(id => id !== categoryId);
                        }
                        localStorage.setItem("checkedCategories", JSON.stringify(savedCategories));
                    });
                });

                var activeCategory = localStorage.getItem("activeCategory");
                if (activeCategory) {
                    var activeAccordion = document.querySelector('[data-category-id="' + activeCategory + '"]');
                    if (activeAccordion) {
                        var collapseElement = activeAccordion.getAttribute("data-bs-target");
                        document.querySelector(collapseElement).classList.add("show");
                        activeAccordion.classList.remove("collapsed");
                        activeAccordion.setAttribute("aria-expanded", "true");
                    }
                }

                document.querySelectorAll(".accordion-button").forEach(function (button) {
                    button.addEventListener("click", function () {
                        var categoryId = this.getAttribute("data-category-id");
                        if (document.querySelector(this.getAttribute("data-bs-target")).classList.contains("show")) {
                            localStorage.removeItem("activeCategory");
                        } else {
                            localStorage.setItem("activeCategory", categoryId);
                        }
                    });
                });
            });
        </script>

        <style>
            .current-category>a {
                font-weight: bold;
                color: #ff6600;
            }

            .category-checkbox {
                display: none;
            }

            span.customcheck {
                background: #FFFFFF 0% 0% no-repeat padding-box;
                border: 1px solid #BEC0C5;
                border-radius: 0px;
                width: 15px;
                height: 15px;
                position: relative;
                margin-right: 2px;
                margin-top: 0px;
                top: 2px;
                display: inline-block;
            }

            .current-category [type=checkbox]:checked~a span.customcheck {
                background: #BEC0C5;
                border-color: #BEC0C5;
            }

            .current-category [type=checkbox]~a .customcheck:after {
                content: "";
                position: absolute;
            }

            .current-category a input:checked~.customcheck:after {
                display: block;
            }

            .current-category a .customcheck:after {
                left: 5px;
                top: 2px;
                width: 4px;
                height: 8px;
                border: solid white;
                border-width: 0 2px 2px 0;
                -webkit-transform: rotate(45deg);
                -ms-transform: rotate(45deg);
                transform: rotate(45deg);
            }
        </style>
        <?php
        return ob_get_clean();
    }
}

add_shortcode('product_categories_accordion', 'wpb_woocommerce_product_categories_accordion');

// product category for sidebar end -------------------------------







// woocommerce category list start------------------
function display_woocommerce_categories()
{
    ob_start();

    $main_categories = get_terms([
        'taxonomy' => 'product_cat',
        'parent' => 0,
        'hide_empty' => true
    ]);

    if (!empty($main_categories)):
        echo '<ul class="product_categories">';
        foreach ($main_categories as $main_cat):
            $sub_categories = get_terms([
                'taxonomy' => 'product_cat',
                'parent' => $main_cat->term_id,
                'hide_empty' => true
            ]);

            $has_subcategories = !empty($sub_categories);

            echo '<li class="categories-nav">';
            echo '<a href="' . get_term_link($main_cat) . '" class="d-flex align-items-center justify-content-between categories-item">' .
                $main_cat->name .
                ($has_subcategories ? ' <i class="fas fa-caret-right"></i>' : '') .
                '</a>';

            if ($has_subcategories):
                echo '<div class="subcategories">';
                echo '<ul class="sub-list">';

                foreach ($sub_categories as $sub_cat):

                    $sub_sub_categories = get_terms([
                        'taxonomy' => 'product_cat',
                        'parent' => $sub_cat->term_id,
                        'hide_empty' => false
                    ]);

                    $has_sub_subcategories = !empty($sub_sub_categories);



                    if ($has_sub_subcategories):
                        foreach ($sub_sub_categories as $sub_sub_cat):
                            echo '<li><a href="' . get_term_link($sub_sub_cat) . '">' . $sub_sub_cat->name . '</a></li>';
                        endforeach;
                    else:
                        echo '<li><a href="' . get_term_link($sub_cat) . '">' . $sub_cat->name . '</a></li>';
                    endif;


                endforeach;

                echo '</ul>';
                echo '</div>';
            endif;

            echo '</li>';
        endforeach;
        echo '</ul>';
    endif;

    return ob_get_clean();
}
add_shortcode('woo_category_list', 'display_woocommerce_categories');


function custom_woocommerce_category_menu()
{
    ob_start();
    ?>
    <ul class="product_categories">
        <?php
        $args = array(
            'taxonomy' => 'product_cat',
            'orderby' => 'name',
            'pad_counts' => false,
            'hierarchical' => true,
            'hide_empty' => false,
            'parent' => 0,
        );

        $product_categories = get_terms($args);

        foreach ($product_categories as $cat) {
            $sub_cats = get_terms(array(
                'taxonomy' => 'product_cat',
                'parent' => $cat->term_id,
                'hide_empty' => false,
            ));

            echo '<li class="categories-nav">';

            if (!empty($sub_cats)) {
                // Not clickable, has children
                echo '<span class="d-flex align-items-center justify-content-between categories-item">';
                echo esc_html($cat->name);
                echo ' <i class="fas fa-caret-right"></i></span>';
            } else {
                // Clickable, no children
                echo '<a href="' . esc_url(get_term_link($cat)) . '" class="d-flex align-items-center justify-content-between categories-item">';
                echo esc_html($cat->name) . '</a>';
            }

            if (!empty($sub_cats)) {
                echo '<div class="subcategories"><ul class="sub-list">';
                foreach ($sub_cats as $sub_cat) {
                    $sub_sub_cats = get_terms(array(
                        'taxonomy' => 'product_cat',
                        'parent' => $sub_cat->term_id,
                        'hide_empty' => false,
                    ));

                    echo '<li class="categories-nav">';

                    if (!empty($sub_sub_cats)) {
                        echo '<span>' . esc_html($sub_cat->name) . ' <i class="fas fa-caret-right"></i></span>';
                    } else {
                        echo '<a href="' . esc_url(get_term_link($sub_cat)) . '">' . esc_html($sub_cat->name) . '</a>';
                    }

                    if (!empty($sub_sub_cats)) {
                        echo '<div class="sub-subcategories"><ul class="sub-list">';
                        foreach ($sub_sub_cats as $sub_sub_cat) {
                            echo '<li><a href="' . esc_url(get_term_link($sub_sub_cat)) . '">' . esc_html($sub_sub_cat->name) . '</a></li>';
                        }
                        echo '</ul></div>';
                    }

                    echo '</li>';
                }
                echo '</ul></div>';
            }

            echo '</li>';
        }
        ?>
    </ul>
    <?php
    return ob_get_clean();
}
add_shortcode('custom_product_categories', 'custom_woocommerce_category_menu');






function custom_scroll_script()
{
    ?>
    <script type="text/javascript">
        (function ($) {
            $(document).ready(function () {
                $(window).scroll(function () {
                    if ($(this).scrollTop() > 20) {
                        $('body').addClass('scrolled');
                    } else {
                        $('body').removeClass('scrolled');
                    }
                });
            });
        })(jQuery);
    </script>

    <script>
        document.addEventListener('DOMContentLoaded', function () {
            const columns = document.querySelectorAll('.custom-columns .elementor-column');

            columns.forEach(col => {
                col.addEventListener('click', function () {
                    columns.forEach(c => c.classList.remove('active'));
                    this.classList.add('active');
                });
            });
        });
    </script>


    <?php
}
add_action('wp_footer', 'custom_scroll_script');



// validation woocommerce start --------------------

add_action('woocommerce_save_account_details_errors', 'validate_my_account_fields', 10, 1);

function validate_my_account_fields($errors)
{
    // Validate First Name
    if (isset($_POST['account_first_name']) && !preg_match('/^[a-zA-Z\s]+$/', $_POST['account_first_name'])) {
        $errors->add('validation', __('Allowed characters for First Name are alphabets and spaces only.', 'woocommerce'));
    }

    // Validate Last Name
    if (isset($_POST['account_last_name']) && !preg_match('/^[a-zA-Z\s]+$/', $_POST['account_last_name'])) {
        $errors->add('validation', __('Allowed characters for Last Name are alphabets and spaces only.', 'woocommerce'));
    }

    // Validate Display Name
    if (isset($_POST['account_display_name']) && !preg_match('/^[a-zA-Z\s]+$/', $_POST['account_display_name'])) {
        $errors->add('validation', __('Allowed characters for Display Name are alphabets and spaces only.', 'woocommerce'));
    }
}




add_action('woocommerce_after_save_address_validation', 'validate_billing_address_fields', 10, 2);

function validate_billing_address_fields($user_id, $address_type)
{
    if ('billing' === $address_type) {
        // Initialize an array to store error messages
        $validation_errors = [];

        // Get the values of the fields from the form
        $billing_first_name = isset($_POST['billing_first_name']) ? sanitize_text_field($_POST['billing_first_name']) : '';
        $billing_last_name = isset($_POST['billing_last_name']) ? sanitize_text_field($_POST['billing_last_name']) : '';
        $billing_city = isset($_POST['billing_city']) ? sanitize_text_field($_POST['billing_city']) : '';
        $billing_address_1 = isset($_POST['billing_address_1']) ? sanitize_text_field($_POST['billing_address_1']) : '';

        $billing_postcode = isset($_POST['billing_postcode']) ? sanitize_text_field($_POST['billing_postcode']) : '';
        $billing_email = isset($_POST['billing_email']) ? sanitize_email($_POST['billing_email']) : '';

        // Validate Billing First Name (Only alphabets and spaces allowed)
        if (!preg_match('/^[a-zA-Z\s]+$/', $billing_first_name)) {
            $validation_errors[] = __('Allowed characters for Billing First Name are alphabets and spaces only.', 'woocommerce');
        }

        // Validate Billing Last Name (Only alphabets and spaces allowed)
        if (!preg_match('/^[a-zA-Z\s]+$/', $billing_last_name)) {
            $validation_errors[] = __('Allowed characters for Billing Last Name are alphabets and spaces only.', 'woocommerce');
        }

        // Validate Billing Last Name (Only alphabets and spaces allowed)
        if (!preg_match('/^[a-zA-Z\s]+$/', $billing_city)) {
            $validation_errors[] = __('Allowed characters for Billing City Name are alphabets and spaces only.', 'woocommerce');
        }

        // Validate Address (Only letters, numbers, and spaces)
        if (!preg_match('/^[a-zA-Z0-9\s]+$/', $billing_address_1)) {
            $validation_errors[] = __('Address must contain only letters, numbers, and spaces.', 'woocommerce');
        }

        // Validate Postcode (Only numbers, 4-10 digits)
        if (!preg_match('/^\d{4,6}$/', $billing_postcode)) {
            $validation_errors[] = __('Postcode must be a number between 4 and 6 digits.', 'woocommerce');
        }



        // Validate Billing Email (Basic Email validation)
        if (!is_email($billing_email)) {
            $validation_errors[] = __('Please enter a valid email address.', 'woocommerce');
        }

        // If there are validation errors, stop the form submission and display the errors
        if (!empty($validation_errors)) {
            // Add all validation errors as WooCommerce notices
            foreach ($validation_errors as $error_message) {
                wc_add_notice($error_message, 'error');  // Add error messages
            }

            // Stop the form submission by returning early
            return; // This will prevent the address from being saved
        }
    }
}








add_action('woocommerce_after_save_address_validation', 'validate_shipping_address_fields', 10, 2);

function validate_shipping_address_fields($user_id, $address_type)
{
    if ('shipping' === $address_type) {
        // Initialize an array to store error messages
        $validation_errors = [];

        // Get the values of the fields from the form
        $shipping_first_name = isset($_POST['shipping_first_name']) ? sanitize_text_field($_POST['shipping_first_name']) : '';
        $shipping_last_name = isset($_POST['shipping_last_name']) ? sanitize_text_field($_POST['shipping_last_name']) : '';
        $shipping_city = isset($_POST['shipping_city']) ? sanitize_text_field($_POST['shipping_city']) : '';
        $shipping_address_1 = isset($_POST['shipping_address_1']) ? sanitize_text_field($_POST['shipping_address_1']) : '';

        $shipping_postcode = isset($_POST['shipping_postcode']) ? sanitize_text_field($_POST['shipping_postcode']) : '';
        //  $shipping_email = isset($_POST['shipping_email']) ? sanitize_email($_POST['shipping_email']) : '';

        // Validate shipping First Name (Only alphabets and spaces allowed)
        if (!preg_match('/^[a-zA-Z\s]+$/', $shipping_first_name)) {
            $validation_errors[] = __('Allowed characters for shipping First Name are alphabets and spaces only.', 'woocommerce');
        }

        // Validate shipping Last Name (Only alphabets and spaces allowed)
        if (!preg_match('/^[a-zA-Z\s]+$/', $shipping_last_name)) {
            $validation_errors[] = __('Allowed characters for shipping Last Name are alphabets and spaces only.', 'woocommerce');
        }

        // Validate shipping Last Name (Only alphabets and spaces allowed)
        if (!preg_match('/^[a-zA-Z\s]+$/', $shipping_city)) {
            $validation_errors[] = __('Allowed characters for shipping City Name are alphabets and spaces only.', 'woocommerce');
        }

        // Validate Address (Only letters, numbers, and spaces)
        if (!preg_match('/^[a-zA-Z0-9\s]+$/', $shipping_address_1)) {
            $validation_errors[] = __('Address must contain only letters, numbers, and spaces.', 'woocommerce');
        }

        // Validate Postcode (Only numbers, 4-10 digits)
        if (!preg_match('/^\d{4,6}$/', $shipping_postcode)) {
            $validation_errors[] = __('Postcode must be a number between 4 and 6 digits.', 'woocommerce');
        }



        // Validate shipping Email (Basic Email validation)
        // if (!is_email($shipping_email)) {
        //     $validation_errors[] = __('Please enter a valid email address.', 'woocommerce');
        // }

        // If there are validation errors, stop the form submission and display the errors
        if (!empty($validation_errors)) {
            // Add all validation errors as WooCommerce notices
            foreach ($validation_errors as $error_message) {
                wc_add_notice($error_message, 'error');  // Add error messages
            }

            // Stop the form submission by returning early
            return; // This will prevent the address from being saved
        }
    }
}




// validation woocommerce end --------------------




// Validate text fields (only alphabets allowed)
add_filter('wpcf7_validate_text', 'alpha_validation_filter_text', 20, 2);
add_filter('wpcf7_validate_text*', 'alpha_validation_filter_text', 20, 2);

function alpha_validation_filter_text($result, $tag)
{
    if (class_exists('WPCF7_FormTag')) {
        $tag = new WPCF7_FormTag($tag); // Corrected class
    }

    if ('names' === $tag->name) {
        $name_of_the_input = isset($_POST[$tag->name]) ? trim($_POST[$tag->name]) : '';

        if (!preg_match('/^[a-zA-Z\s]+$/', $name_of_the_input)) {
            $result->invalidate($tag, "Allowed characters are Alphabets only.");
        }
    }

    return $result;
}

// Validate phone number (must be exactly 10 digits)
add_filter('wpcf7_validate_tel', 'numeric_phone_validation_filter', 20, 2);
add_filter('wpcf7_validate_tel*', 'numeric_phone_validation_filter', 20, 2);

function numeric_phone_validation_filter($result, $tag)
{
    if (class_exists('WPCF7_FormTag')) {
        $tag = new WPCF7_FormTag($tag); // Corrected class
    }

    if ('tel-257' === $tag->name) {
        $phone_number = isset($_POST[$tag->name]) ? trim($_POST[$tag->name]) : '';

        if (!preg_match('/^\d{10}$/', $phone_number)) {
            $result->invalidate($tag, "Phone number must contain exactly 10 digits.");
        }
    }

    return $result;
}



// Validate email (must be a valid email format)
add_filter('wpcf7_validate_email', 'validate_email_filter', 20, 2);
add_filter('wpcf7_validate_email*', 'validate_email_filter', 20, 2);

function validate_email_filter($result, $tag)
{
    if (class_exists('WPCF7_FormTag')) {
        $tag = new WPCF7_FormTag($tag); // Corrected class
    }

    if ('email' === $tag->name) {
        $email = isset($_POST[$tag->name]) ? trim($_POST[$tag->name]) : '';

        if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
            $result->invalidate($tag, "Please enter a valid email address.");
        }
    }

    return $result;
}





// Validate textarea field (message)
add_filter('wpcf7_validate_textarea', 'validate_textarea_filter', 20, 2);
add_filter('wpcf7_validate_textarea*', 'validate_textarea_filter', 20, 2);

function validate_textarea_filter($result, $tag)
{
    if (class_exists('WPCF7_FormTag')) {
        $tag = new WPCF7_FormTag($tag); // Corrected class
    }

    if ('message' === $tag->name) {
        $message = isset($_POST[$tag->name]) ? trim($_POST[$tag->name]) : '';

        // Allowed characters: alphabets, spaces, common punctuation marks
        if (!preg_match('/^[a-zA-Z0-9\s.,!?()-]+$/', $message)) {
            $result->invalidate($tag, "Message contains invalid characters. Only letters, numbers, spaces, and punctuation are allowed.");
        }

        // Min 10 characters, Max 500 characters
        if (strlen($message) < 10 || strlen($message) > 500) {
            $result->invalidate($tag, "Message must be between 10 and 500 characters.");
        }
    }

    return $result;
}
