<?php get_header(); ?>
<div class="page-single">


    <?php
    if (have_posts()):
        while (have_posts()):
            the_post();
            ?>

            <div class="banner-main">
                <?php
                $banner_image_id = get_field('banner_image'); // Returns attachment ID
                if (!empty($banner_image_id)) {
                    $image_url = wp_get_attachment_image_url($banner_image_id, 'full');
                    echo '<img src="' . esc_url($image_url) . '" alt="">';
                } else { ?>
                    <img src="http://localhost:8888/wp/thor-international/wp-content/uploads/2025/04/Banner-5.jpg" class="w-100">
                <?php }
                ?>
                <div class="container banner-resources">

                    <div class="col-lg-12">
                        <h6 class="elementor-heading-title elementor-size-default">RESOURCES</h6>
                        <h1 class="elementor-heading-title elementor-size-default"> <?php the_title(); ?> </h1>
                    </div>
                </div>
            </div>




            <div class="container pt-5 pb-5" id="<?php echo get_the_ID(); ?>">
                <div class="row justify-content-center">
                    <div class="col-lg-12">
                        <div class="row justify-content-end mx-0 border-bottom mb-5">
                            <div class="col-md-3">
                                <form action="">
                                    <input type="search" placeholder="Search" class="border rounded-5 mb-2">
                                </form>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-12">

                        <?php
                        $part_numbers = get_field('part_numbers'); // Or SCF::get() if using Smart Custom Fields
                
                        if (!empty($part_numbers)): ?>

                            <div class="table-responsive">
                                <table class="table table-striped table-bordered port-number-table">
                                    <thead>
                                        <tr>
                                            <th>OTHERS #</th>
                                            <th>GAGE BILT #</th>
                                            <th>DESCRIPTION</th>
                                        </tr>
                                    </thead>
                                    <tbody>

                                        <?php foreach ($part_numbers as $item): ?>
                                            <tr>
                                                <td><?php echo esc_html($item['others']); ?></td>
                                                <td><?php echo esc_html($item['gage_bilt']); ?></td>
                                                <td><?php echo esc_html($item['description']); ?></td>
                                            </tr>
                                        <?php endforeach; ?>

                                    </tbody>
                                </table>
                            </div>

                        <?php endif; ?>

                    </div>
                </div>
            </div>


            <!-- <div class="container">
                <div class="row justify-content-center">
                    <div class="col-lg-10 pb-5">
                        <?php //the_content(); ?>
                    </div>
                </div>
            </div> -->


        <?php endwhile;
    else:
        echo '<p>' . __('No Post found', 'textdomain') . '</p>';
        ?>

        <?php
        wp_reset_postdata();
    endif;
    ?>

</div>


<?php echo do_shortcode('[hfe_template id="299"]'); ?>


<?php get_footer(); ?>