<?php get_header(); ?>
<div class="page-single">

    <?php
    if (have_posts()):
        while (have_posts()):
            the_post();
            ?>

            <div class="pt-0" id="<?php echo get_the_ID(); ?>">
                <div class="category-detail-box">
                <?php
                $banner_image_id = get_field('banner_image'); // Returns attachment ID
                if (!empty($banner_image_id)) {
                    $image_url = wp_get_attachment_image_url($banner_image_id, 'full');
                    echo '<img src="' . esc_url($image_url) . '" alt="">';
                }else{ ?>
                    <img src="http://localhost:8888/wp/thor-international/wp-content/uploads/2025/04/Banner-5.jpg" class="w-100">
              <?php  }
                ?>
                    <div class="blog-header">
                        <span class="badge">TECHNICAL INFORMATION</span>
                        <h2 class="mt-0"><?php the_title(); ?></h2>
                        <p class="text-center"><span><?php echo get_the_date('M j, Y'); ?></span></p>
                    </div>
                </div>
            </div>
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-lg-10 pb-5">
                        <?php the_content(); ?>
                    </div>
                </div>
            </div>

            <?php
            $post_images = get_field('post_images');

            if (!empty($post_images)):
                echo '<div class="slick-slider-blog pb-2">';
                foreach ($post_images as $item) {
                    $image_url = wp_get_attachment_image_url($item['slider_item'], 'full'); // Get image URL from attachment ID
                    if ($image_url) {
                        echo '<div class="item p-2">';
                        echo '<img src="' . esc_url($image_url) . '" alt="" class="w-100 rounded-3">';
                        echo '</div>';
                    }
                }
                echo '</div>';
            endif;
            ?>

            <script>
                jQuery(document).ready(function ($) {
                    $(".slick-slider-blog").slick({
                        dots: true,
                        infinite: true,
                        speed: 300,
                        slidesToShow: 2,
                        centerMode: true,
                        centerPadding: "260px",
                        slidesToScroll: 1,
                        adaptiveHeight: true,
                        prevArrow: "#tes-prev",
                        nextArrow: "#tes-next",
                        responsive: [{
                            breakpoint: 1200,
                            settings: {
                                slidesToShow: 2,
                                slidesToScroll: 1,
                            },
                        },
                        {
                            breakpoint: 1008,
                            settings: {
                                slidesToShow: 1,
                                slidesToScroll: 1,
                                centerPadding: "160px",
                            },
                        },
                        {
                            breakpoint: 800,
                            settings: {
                                slidesToShow: 1,
                                slidesToScroll: 1,
                                centerPadding: "100px",
                            },
                        },
                        {
                            breakpoint: 500,
                            settings: {
                                slidesToShow: 1,
                                slidesToScroll: 1,
                                centerPadding: "60px",
                            },
                        },
                        ],
                    });

                });
            </script>

            <!-- <div class="container text-end border-top pt-4 mt-5 pb-5">
                <a href="" class="next-blog">
                    <small>NEXT <img src="http://localhost:8888/wp/thor-international/wp-content/uploads/2025/04/arrow.png"
                            alt=""></small>
                    <span>How sustainable materials are <br> shaping future construction</span>
                </a>
            </div> -->

            <div class="container text-end border-top pt-4 mt-5 pb-5">
                <?php
                $next_post = get_adjacent_post(false, '', true); // Get next post (regardless of category)
        
                if (!empty($next_post)):
                    $next_post_url = get_permalink($next_post->ID);
                    $next_post_title = get_the_title($next_post->ID);
                    ?>
                    <a href="<?php echo esc_url($next_post_url); ?>" class="next-blog">
                        <small>NEXT <img src="https://draftsite1.com/thor-international/wp-content/uploads/2025/04/arrow.png"
                                alt=""></small>
                        <span><?php echo esc_html($next_post_title); ?></span>
                    </a>
                <?php endif; ?>
            </div>


        <?php endwhile;
    else:
        echo '<p>' . __('No Post found', 'textdomain') . '</p>';
        ?>

        <?php
        wp_reset_postdata();
    endif;
    ?>

</div>


<?php echo do_shortcode('[hfe_template id="299"]'); ?>


<?php get_footer(); ?>