<?php
// Enqueue the parent theme's stylesheet

function hello_elementor_child_enqueue_styles()
{
    wp_enqueue_style('hello-elementor-parent-style', get_template_directory_uri() . '/../hello-elementor-child/style.css');
    wp_enqueue_style('hello-elementor-parent-ecommerce', get_template_directory_uri() . '/../hello-elementor-child/ecommerce.css');
}
add_action('wp_enqueue_scripts', 'hello_elementor_child_enqueue_styles');




// Enqueue Booststrap 
function enqueue_bootstrap()
{
    wp_enqueue_style('bootstrap-css', 'https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css');
    //  wp_enqueue_script('bootstrap-js', 'https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.min.js', array('jquery'), null, true);

    // Load Bootstrap Bundle JS only when NOT on Portfolio page (or post)
    if (!is_page('gallery') && !is_singular('gallery')) {
        wp_enqueue_script('bootstrap-js', 'https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.min.js', array('jquery'), null, true);
    }
}
add_action('wp_enqueue_scripts', 'enqueue_bootstrap');


//  Slick carousel script and styles
function enqueue_slick_scripts()
{
    //  Slick carousel script
    wp_enqueue_script('slick-js', 'https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.9.0/slick.min.js', array('jquery'), null, true);
    //  Slick carousel CSS
    wp_enqueue_style('slick-css', 'https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.9.0/slick.min.css');
}
add_action('wp_enqueue_scripts', 'enqueue_slick_scripts');

// custom code

function custom_scroll_script() {
    ?>
    <script type="text/javascript">
    (function($) {
        $(document).ready(function() {
            $(window).scroll(function() {
                if ($(this).scrollTop() > 1) {
                    $('body').addClass('scrolled');
                } else {
                    $('body').removeClass('scrolled');
                }
            });
        });
    })(jQuery);
    </script>
    <?php
}
add_action('wp_footer', 'custom_scroll_script');


// Home slider Start --------------------------------------------
function display_banner_home($atts)
{
    $args = array(
        'post_type' => 'main-slider',
    );

    $mainslider_query = new WP_Query($args);

    ob_start();

    if ($mainslider_query->have_posts()):
        $total_slides = $mainslider_query->post_count;
        ?>
        <div id="demo" class="carousel slide hero-banner carousel-fade" data-bs-ride="carousel">
            <div class="carousel-inner">
                <?php
                $first = true;
                while ($mainslider_query->have_posts()):
                    $mainslider_query->the_post(); ?>

                    <div class="carousel-item <?php echo $first ? 'active' : ''; ?>">
                        <?php if (has_post_thumbnail()) {
                            the_post_thumbnail('full', array('class' => 'd-block w-100'));
                        } ?>
                        <div class="carousel-caption">
                            <div class="container">
                                <div class="row">
                                    <div class="col-md-6 animated slideInLeft"
                                        data-settings="{&quot;_animation&quot;:&quot;slideInLeft&quot;}">
                                        <h3><?php the_title(); ?></h3>
                                        <div class="btnlight pt-3">
                                            <?php
                                            $links = get_field('button_link');
                                            if ($links) {
                                                $link_url = $links['url'];
                                                $link_title = $links['title'];
                                                ?>
                                                <a href="<?php echo esc_url($link_url); ?>" class="elementor-button theme-btn-custom">
                                                    <?php echo esc_html($link_title); ?>

                                                    <span class="elementor-button-icon">
                                                        <svg class="e-font-icon-svg e-fas-arrow-right" viewBox="0 0 448 512"
                                                            xmlns="http://www.w3.org/2000/svg">
                                                            <path
                                                                d="M190.5 66.9l22.2-22.2c9.4-9.4 24.6-9.4 33.9 0L441 239c9.4 9.4 9.4 24.6 0 33.9L246.6 467.3c-9.4 9.4-24.6 9.4-33.9 0l-22.2-22.2c-9.5-9.5-9.3-25 .4-34.3L311.4 296H24c-13.3 0-24-10.7-24-24v-32c0-13.3 10.7-24 24-24h287.4L190.9 101.2c-9.8-9.3-10-24.8-.4-34.3z">
                                                            </path>
                                                        </svg>
                                                    </span>

                                                </a>
                                            <?php } ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php
                    $first = false;
                endwhile; ?>
            </div>

            <?php if ($total_slides > 1): ?>
                <div class="arrow-control-bottom">
                    <div class="container">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="arrow-control-slider">
                                    <span class="control-prev" data-bs-target="#demo" data-bs-slide="prev">
                                        <i class="fa fa-arrow-left"></i>
                                    </span>
                                    <span class="control-next" data-bs-target="#demo" data-bs-slide="next">
                                        <i class="fa fa-arrow-right"></i>
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
            <?php endif; ?>


        </div>

    <?php else: ?>
        <div>No Slider found.</div>
    <?php endif;

    wp_reset_postdata();

    return ob_get_clean();
}
add_shortcode('banner_home', 'display_banner_home');


// Home slider end --------------------------------------------



// testimonials slider start------------------
function display_testimonials_slider($atts)
{
    // Attributes
    $atts = shortcode_atts(
        array(
            'posts_per_page' => 6,
        ),
        $atts,
        'testimonials'
    );

    $args = array(
        'post_type' => 'testimonials',
        'posts_per_page' => $atts['posts_per_page'],
        // 'meta_query' => array(
        //     array(
        //         'key' => '_is_ns_featured_post',
        //         'value' => 'yes',
        //         'compare' => '='
        //     )
        // )
    );

    $testimonials_query = new WP_Query($args);


    ob_start();

    if ($testimonials_query->have_posts()): ?>
        <div class="testimonials-slider">
            <div class="slick-slider-testimonials">
                <?php while ($testimonials_query->have_posts()):
                    $testimonials_query->the_post();
                    ?>

                    <div class="item ps-2 pe-2">
                        <div class="testimonials-box" id="<?php echo get_the_ID(); ?>">
                            <div class="img-wrap">
                                <?php if (has_post_thumbnail()) {
                                    the_post_thumbnail('full', array('class' => 'd-block w-100'));
                                } ?>
                            </div>
                            <div class="testimonials-wrap">
                                <h1 class="title"> <?php echo get_the_title(); ?> </h1>
                                <?php
                                $position = get_field('position');
                                if ($position):
                                    echo '<p class="position mb-0">';
                                    echo $position;
                                    echo '</p>';
                                endif; ?>
                            </div>

                            <div class="quate-img pt-4 pb-4">
                                <img src="http://localhost:8888/wp/uni-drive-systems/wp-content/uploads/2025/07/quote-1.svg" alt="">
                            </div>

                            <div class="content-box">
                                <div class="description"> <?php echo get_the_content(); ?>
                                </div>

                                <?php
                                $content = get_the_content();
                                $word_count = str_word_count(wp_strip_all_tags(strip_shortcodes($content)));
                                if ($word_count > 25):
                                    ?>
                                    <a data-bs-toggle="modal" data-bs-target="#exampleModal<?php echo get_the_ID(); ?>"
                                        class="read-more-testimonial"> Read More</a>
                                <?php endif; ?>


                            </div>
                            <div class="rating-area">
                                <?php
                                $rating = get_field('rating');
                                if ($rating):
                                    echo '<div class="rating">';
                                    echo str_repeat('★', $rating);
                                    echo '</div>';
                                endif;
                                ?>
                            </div>

                        </div>

                    </div>
                <?php endwhile; ?>
            </div>
        </div>

        <?php while ($testimonials_query->have_posts()):
            $testimonials_query->the_post(); ?>
            <div class="model-testimonial modal modal-md" id="exampleModal<?php echo get_the_ID(); ?>" tabindex="-1"
                aria-labelledby="exampleModalLabel" aria-hidden="true">
                <div class="modal-dialog modal-lg modal-dialog-centered">
                    <div class="modal-content">
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        <div class="modal-body p-0">


                            <div class="testimonial-model">
                                <div class="testimonials-box-popup" id="<?php echo get_the_ID(); ?>">
                                    <div class="row">
                                        <div class="col-md-3">
                                            <div class="img-wrap">
                                                <?php if (has_post_thumbnail()) {
                                                    the_post_thumbnail('full', array('class' => 'd-block w-100'));
                                                } ?>
                                            </div>
                                        </div>
                                        <div class="col-md-9">
                                            <div class="testimonials-wrap">
                                                <h1 class="title mt-0"> <?php echo get_the_title(); ?> </h1>
                                                <?php
                                                $position = get_field('position');
                                                if ($position):
                                                    echo '<p class="position mb-0">';
                                                    echo $position;
                                                    echo '</p>';
                                                endif; ?>
                                            </div>

                                            <div class="rating-area">
                                                <?php
                                                $rating = get_field('rating');
                                                if ($rating):
                                                    echo '<div class="rating">';
                                                    echo str_repeat('★', $rating);
                                                    echo '</div>';
                                                endif;
                                                ?>
                                            </div>

                                            <div class="content-box">
                                                <div class="description">
                                                    <?php echo get_the_content(); ?>
                                                </div>
                                            </div>

                                        </div>
                                    </div>

                                </div>
                            </div>


                        </div>
                    </div>
                </div>
            </div>

        <?php endwhile; ?>

        <script>
            jQuery(document).ready(function ($) {
                $(".slick-slider-testimonials").slick({
                    dots: true,
                    arrows: false,
                    infinite: true,
                    autoplay: false,
                    speed: 300,
                    slidesToShow: 3,
                    slidesToScroll: 1,
                    adaptiveHeight: true,
                    prevArrow: '<div class="left-btn arrowbtn"> <img src="http://localhost:8888/wp/Jin-yinmemorial/wp-content/uploads/2025/06/back.png"> </div>',
                    nextArrow: '<div class="right-btn arrowbtn"><img src="http://localhost:8888/wp/Jin-yinmemorial/wp-content/uploads/2025/06/back.png"></div>',
                    responsive: [{
                        breakpoint: 1200,
                        settings: {
                            slidesToShow: 3,
                            slidesToScroll: 1,
                        },
                    },
                    {
                        breakpoint: 1008,
                        settings: {
                            slidesToShow: 2,
                            slidesToScroll: 1,
                        },
                    },
                    {
                        breakpoint: 800,
                        settings: {
                            slidesToShow: 1,
                            slidesToScroll: 1,
                        },
                    },
                    ],
                });

            });
        </script>

    <?php else:
        echo 'No testimonials found.';
    endif;

    wp_reset_postdata();

    return ob_get_clean();
}
add_shortcode('testimonials_slider', 'display_testimonials_slider');
// testimonials slider end ------------------------------

function custom_services_taxonomy_posts_per_page($query)
{
    if (
        !is_admin() &&
        $query->is_main_query() &&
        is_tax('services-category')
    ) {
        $query->set('posts_per_page', 4);
    }
}
add_action('pre_get_posts', 'custom_services_taxonomy_posts_per_page');


function custom_products_tax_posts_per_page($query)
{
    if (
        !is_admin() &&
        $query->is_main_query() &&
        is_tax('products-category')
    ) {
        $query->set('posts_per_page', 2);
    }
}
add_action('pre_get_posts', 'custom_products_tax_posts_per_page');



// training page start ------------------------------------------------------------


function display_training($atts)
{
    // Attributes
    $atts = shortcode_atts(
        array(
            'posts_per_page' => 6,
        ),
        $atts,
        'training'
    );

    // Get the current page


    $args = array(
        'post_type' => 'utraining',
        'posts_per_page' => $atts['posts_per_page'],
        'paged' => get_query_var('paged') ? get_query_var('paged') : 1,
        'orderby' => 'date',
        'order' => 'DESC',
    );


    $training_query = new WP_Query($args);

    ob_start();

    if ($training_query->have_posts()): ?>
        <div class="training-page training-main">
            <div class="row g-md-5 g-3">
                <?php while ($training_query->have_posts()):
                    $training_query->the_post();
                    ?>
                    <div class="col-md-6">

                        <div class="training-box show-more-content-btn" id="<?php echo get_the_ID(); ?>">
                            <div class="training-img">
                                <?php if (has_post_thumbnail()) {
                                    the_post_thumbnail('full', array('class' => 'd-block w-100'));
                                } ?>
                            </div>

                            <div class="training-info">
                                <div class="training-effect">
                                    <div class="training-wrap">
                                        <h1 class="training-heading"><?php echo get_the_title(); ?> </h1>
                                        <p class="excerpt-training">
                                            <?php echo get_the_excerpt(); ?>
                                        </p>
                                        <a href="<?php the_permalink(); ?>" class="view-more-btn">
                                            View More <i class="fa fa-arrow-right ms-2"></i>
                                        </a>

                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endwhile; ?>
            </div>

            <script type="text/javascript">
                document.addEventListener('DOMContentLoaded', function () {
                    var listItems = document.querySelectorAll('#category-filter-list a');
                    listItems.forEach(function (item) {
                        item.addEventListener('click', function (event) {
                            // No need to prevent default here; the link's href handles the filtering
                        });
                    });
                });
            </script>




            <?php if ($training_query->max_num_pages > 1): ?>
                <div class="pagination-center text-center mt-md-5 mt-3 mb-3">
                    <div class="pagination-two">
                        <?php
                        echo paginate_links(array(
                            'total' => $training_query->max_num_pages,
                            'current' => max(1, get_query_var('paged')),
                            'format' => '?paged=%#%',
                            'show_all' => false,
                            'type' => 'plain',
                            'prev_text' => '<i class="eicon-chevron-left"></i>',
                            'next_text' => '<i class="eicon-chevron-right"></i>',
                            'end_size' => 2,
                            'mid_size' => 2
                        ));
                        ?>
                    </div>
                </div>
            <?php endif; ?>


        <?php else:
        echo 'No training found.';
    endif;

    wp_reset_postdata();

    return ob_get_clean();
}
add_shortcode('training', 'display_training');


// training list end------------




// portfolio page start ------------------------------------------------------------


function display_portfolio($atts)
{
    // Attributes
    $atts = shortcode_atts(
        array(
            'posts_per_page' => 8,
            'category' => isset($_GET['category']) ? sanitize_text_field($_GET['category']) : '',
        ),
        $atts,
        'portfolio'
    );

    // Get the current page


    $args = array(
        'post_type' => 'portfolio',
        'posts_per_page' => $atts['posts_per_page'],
        'paged' => get_query_var('paged') ? get_query_var('paged') : 1,
        'orderby' => 'date',
        'order' => 'DESC',
    );


    // Filter by category if provided
    if (!empty($atts['category'])) {
        $args['tax_query'] = array(
            array(
                'taxonomy' => 'portfolio-category',
                'field' => 'slug',
                'terms' => $atts['category'],
            ),
        );
    }
    // Get categories
    $categories = get_terms(array(
        'taxonomy' => 'portfolio-category',
        'hide_empty' => true,
        'orderby' => 'date',
        'order' => 'DESC',
    ));

    if ($categories):
        ?>
            <div class="text-center">
                <ul id="project-filter-list" class="mb-4">
                    <li><a href="<?php echo esc_url(add_query_arg('category', '', home_url('/our-portfolio'))); ?>"
                            class="cats <?php echo empty($atts['category']) ? 'active' : ''; ?>"> All </a></li>
                    <?php foreach ($categories as $category):
                        $active_class = ($atts['category'] === $category->slug) ? 'active' : '';
                        ?>
                        <li>
                            <a href="<?php echo esc_url(add_query_arg('category', $category->slug, home_url('/our-portfolio'))); ?>"
                                class="cats <?php echo esc_attr($active_class); ?>">
                                <?php echo esc_html($category->name); ?>
                            </a>
                        </li>
                    <?php endforeach; ?>
                </ul>
            </div>
            <?php
    endif;




    $portfolio_query = new WP_Query($args);

    ob_start();

    if ($portfolio_query->have_posts()): ?>
            <div class="portfolio-page portfolio-main">
                <div class="row g-md-5 g-3">
                    <?php while ($portfolio_query->have_posts()):
                        $portfolio_query->the_post();
                        ?>
                        <div class="col-md-6">
                            <div class="portfolio-box show-more-content-btn" id="<?php echo get_the_ID(); ?>">
                                <div class="portfolio-img">
                                    <?php if (has_post_thumbnail()) {
                                        the_post_thumbnail('full', array('class' => 'd-block w-100'));
                                    } ?>
                                </div>

                                <div class="portfolio-info">
                                    <div class="portfolio-effect">
                                        <div class="portfolio-wrap">
                                            <h1 class="title"> <?php echo get_the_title(); ?> </h1>
                                            <p class="excerpt"> <?php echo get_the_excerpt(); ?> </p>
                                        </div>
                                    </div>

                                    <a href="<?php the_permalink(); ?>" class="btn-normal">
                                        VIEW MORE
                                        <span class="elementor-button-icon">
                                            <svg class="e-font-icon-svg e-fas-arrow-right" viewBox="0 0 448 512"
                                                xmlns="http://www.w3.org/2000/svg">
                                                <path
                                                    d="M190.5 66.9l22.2-22.2c9.4-9.4 24.6-9.4 33.9 0L441 239c9.4 9.4 9.4 24.6 0 33.9L246.6 467.3c-9.4 9.4-24.6 9.4-33.9 0l-22.2-22.2c-9.5-9.5-9.3-25 .4-34.3L311.4 296H24c-13.3 0-24-10.7-24-24v-32c0-13.3 10.7-24 24-24h287.4L190.9 101.2c-9.8-9.3-10-24.8-.4-34.3z">
                                                </path>
                                            </svg>
                                        </span>
                                    </a>
                                </div>

                            </div>
                        </div>
                    <?php endwhile; ?>
                </div>

                <script type="text/javascript">
                    document.addEventListener('DOMContentLoaded', function () {
                        var listItems = document.querySelectorAll('#category-filter-list a');
                        listItems.forEach(function (item) {
                            item.addEventListener('click', function (event) {
                                // No need to prevent default here; the link's href handles the filtering
                            });
                        });
                    });
                </script>




                <?php if ($portfolio_query->max_num_pages > 1): ?>
                    <div class="pagination-center text-center mt-md-5 mt-3 mb-3">
                        <div class="pagination-two">
                            <?php
                            echo paginate_links(array(
                                'total' => $portfolio_query->max_num_pages,
                                'current' => max(1, get_query_var('paged')),
                                'format' => '?paged=%#%',
                                'show_all' => false,
                                'type' => 'plain',
                                'prev_text' => '<i class="eicon-chevron-left"></i>',
                                'next_text' => '<i class="eicon-chevron-right"></i>',
                                'end_size' => 2,
                                'mid_size' => 2
                            ));
                            ?>
                        </div>
                    </div>
                <?php endif; ?>


            <?php else:
        echo 'No portfolio found.';
    endif;

    wp_reset_postdata();

    return ob_get_clean();
}
add_shortcode('portfolio', 'display_portfolio');


// portfolio list end------------



// portfolio featured start------------------
function display_portfolio_featured($atts)
{
    // Attributes
    $atts = shortcode_atts(
        array(
            'posts_per_page' => 4,
        ),
        $atts,
        'portfolio'
    );

    $args = array(
        'post_type' => 'portfolio',
        'posts_per_page' => $atts['posts_per_page'],
        'meta_query' => array(
            array(
                'key' => '_is_ns_featured_post',
                'value' => 'yes',
                'compare' => '='
            )
        )
    );

    $portfolio_query = new WP_Query($args);


    ob_start();

    if ($portfolio_query->have_posts()): ?>
                <div class="portfolio-featured">
                    <div class="row g-md-4">
                        <?php while ($portfolio_query->have_posts()):
                            $portfolio_query->the_post();
                            ?>

                            <div class="col-md-6">
                                <div class="portfolio-box show-more-content-btn" id="<?php echo get_the_ID(); ?>">
                                    <div class="portfolio-img">
                                        <?php if (has_post_thumbnail()) {
                                            the_post_thumbnail('full', array('class' => 'd-block w-100'));
                                        } ?>
                                    </div>

                                    <div class="portfolio-info">
                                        <div class="portfolio-effect">
                                            <div class="portfolio-wrap">
                                                <h1 class="title"> <?php echo get_the_title(); ?> </h1>
                                                <p class="excerpt"> <?php echo get_the_excerpt(); ?> </p>
                                            </div>
                                        </div>

                                        <a href="<?php the_permalink(); ?>" class="btn-normal">
                                            VIEW MORE
                                            <span class="elementor-button-icon">
                                                <svg class="e-font-icon-svg e-fas-arrow-right" viewBox="0 0 448 512"
                                                    xmlns="http://www.w3.org/2000/svg">
                                                    <path
                                                        d="M190.5 66.9l22.2-22.2c9.4-9.4 24.6-9.4 33.9 0L441 239c9.4 9.4 9.4 24.6 0 33.9L246.6 467.3c-9.4 9.4-24.6 9.4-33.9 0l-22.2-22.2c-9.5-9.5-9.3-25 .4-34.3L311.4 296H24c-13.3 0-24-10.7-24-24v-32c0-13.3 10.7-24 24-24h287.4L190.9 101.2c-9.8-9.3-10-24.8-.4-34.3z">
                                                    </path>
                                                </svg>
                                            </span>
                                        </a>
                                    </div>

                                </div>

                            </div>
                        <?php endwhile; ?>
                    </div>
                </div>


            <?php else:
        echo 'No portfolio found.';
    endif;

    wp_reset_postdata();

    return ob_get_clean();
}
add_shortcode('portfolio_featured', 'display_portfolio_featured');
// portfolio featured end ------------------------------










// blog page start ------------------------------------------------------------


function display_blog($atts)
{
    // Attributes
    $atts = shortcode_atts(
        array(
            'posts_per_page' => 3,
            'category' => isset($_GET['category']) ? sanitize_text_field($_GET['category']) : '',
        ),
        $atts,
        'blog'
    );

    // Get the current page


    $args = array(
        'post_type' => 'post',
        'posts_per_page' => $atts['posts_per_page'],
        'paged' => get_query_var('paged') ? get_query_var('paged') : 1,
        'orderby' => 'date',
        'order' => 'DESC',
    );



    $selected_category = isset($_GET['category']) ? sanitize_text_field($_GET['category']) : '';

    $args = array(
        'post_type' => 'post',
        'posts_per_page' => $atts['posts_per_page'],
        'paged' => get_query_var('paged') ? get_query_var('paged') : 1,
    );

    if (!empty($selected_category)) {
        $args['category_name'] = $selected_category;
    }


    $blog_query = new WP_Query($args);

    ob_start(); ?>

            <div class="row g-md-5 g-4">
                <div class="col-md-4 order-md-2 order-1">
                    <div class="sidebar-box">

                        <?php
                        $categories = get_categories();
                        if ($categories):
                            ?>
                            <h3 class="cat-color">Categories</h3>
                            <div class="text-start">
                                <ul class="category-list">
                                    <!-- <li><a href="<?php // echo esc_url(add_query_arg('category', '', home_url('/news'))); ?>"
                                            class="cats <?php // echo empty($atts['category']) ? 'active' : ''; ?>"> All  <span>  <?php // echo esc_html($category->name . ' (' . $category->count . ')'); ?> </span> </a></li> -->
                                    <?php foreach ($categories as $category):
                                        $active_class = ($atts['category'] === $category->slug) ? 'active' : '';
                                        ?>
                                        <li>
                                            <a href="<?php echo esc_url(add_query_arg('category', $category->slug, home_url('/news'))); ?>"
                                                class="cats <?php echo esc_attr($active_class); ?>">
                                                <?php echo esc_html($category->name); ?>

                                                <span> <?php echo esc_html(' ' . $category->count . ''); ?> </span>

                                            </a>
                                        </li>
                                    <?php endforeach; ?>
                                </ul>
                            </div>
                            <?php
                        endif; ?>


                        <hr class="sidebar-divider" />

                        <h3 class="cat-color">Recent Posts</h3>
                        <?php
                        $recent_args = array(
                            'post_type' => 'post',
                            'posts_per_page' => 3,
                            'orderby' => 'date',
                            'order' => 'DESC',
                        );
                        $recent_query = new WP_Query($recent_args);

                        if ($recent_query->have_posts()):
                            while ($recent_query->have_posts()):
                                $recent_query->the_post(); ?>
                                <div class="recent-post d-flex mb-3">
                                    <a href="<?php the_permalink(); ?>" class="me-2" style="flex-shrink: 0;">
                                        <?php if (has_post_thumbnail()) {
                                            the_post_thumbnail('thumbnail', array('style' => 'width: 80px; height: auto;'));
                                        } else {
                                            echo '<img src="' . esc_url(get_template_directory_uri() . '/assets/img/default-thumb.jpg') . '" alt="No image" style="width: 80px; height: auto;">';
                                        } ?>
                                    </a>
                                    <div>
                                        <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                                        <div class="recent-date"><?php echo get_the_date(); ?></div>
                                    </div>
                                </div>
                            <?php endwhile;
                        endif;
                        wp_reset_postdata();
                        ?>


                    </div>
                </div>
                <div class="col-md-8 order-md-1 order-2">
                    <?php
                    if ($blog_query->have_posts()): ?>
                        <div class="blog-page blog-main">
                            <div class="row g-md-5 g-3">
                                <?php while ($blog_query->have_posts()):
                                    $blog_query->the_post();
                                    ?>

                                    <div class="blog-post-card">
                                        <div class="blog-image-wrapper">
                                            <a href="<?php the_permalink(); ?>">
                                                <?php if (has_post_thumbnail()) {
                                                    the_post_thumbnail('full', array('class' => 'd-block w-100'));
                                                } ?>
                                            </a>

                                            <?php
                                            $terms = get_the_terms(get_the_ID(), 'category');
                                            if ($terms && !is_wp_error($terms)) { ?>
                                                <?php
                                                foreach ($terms as $term) {
                                                    $category_name = strtolower($term->name); ?>

                                                    <span class="blog-category-badge"><?php echo $category_name; ?></span>

                                                    <?php
                                                } ?>
                                            <?php }
                                            ?>

                                        </div>
                                        <div class="blog-content">
                                            <h2><a href="#"><?php echo get_the_title(); ?></a></h2>
                                            <p>
                                                <?php echo get_the_excerpt(); ?>
                                            </p>
                                            <a href="<?php the_permalink(); ?>" class="read-more-btn">READ MORE</a>
                                        </div>
                                    </div>
                                <?php endwhile; ?>
                            </div>

                            <script type="text/javascript">
                                document.addEventListener('DOMContentLoaded', function () {
                                    var listItems = document.querySelectorAll('#category-filter-list a');
                                    listItems.forEach(function (item) {
                                        item.addEventListener('click', function (event) {
                                            // No need to prevent default here; the link's href handles the filtering
                                        });
                                    });
                                });
                            </script>
                            <?php if ($blog_query->max_num_pages > 1): ?>
                                <div class="pagination-center text-center mt-md-5 mt-3 mb-3">
                                    <div class="pagination-two">
                                        <?php
                                        echo paginate_links(array(
                                            'total' => $blog_query->max_num_pages,
                                            'current' => max(1, get_query_var('paged')),
                                            'format' => '?paged=%#%',
                                            'show_all' => false,
                                            'type' => 'plain',
                                            'prev_text' => '<i class="eicon-chevron-left"></i>',
                                            'next_text' => '<i class="eicon-chevron-right"></i>',
                                            'end_size' => 2,
                                            'mid_size' => 2
                                        ));
                                        ?>
                                    </div>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>

                <?php else:
                        echo 'No blog found.';
                    endif;

                    wp_reset_postdata();

                    return ob_get_clean();
}
add_shortcode('blog', 'display_blog');


// blog list end------------

function get_related_articles($post_id, $number_of_posts = 5)
{

    $args = array(
        'post_type' => 'post',
        'post__not_in' => array($post_id),
        'posts_per_page' => $number_of_posts,
        'ignore_sticky_posts' => 1,
        'orderby' => 'date',
        'order' => 'DESC',
    );

    return get_posts($args);

    $related_posts = get_related_articles(get_the_ID());

    // If not enough related posts by category, get related posts by tag
    if (count($related_posts) < $number_of_posts) {
        $tags = wp_get_post_tags($post_id);
        if ($tags) {
            $tag_ids = array();
            foreach ($tags as $tag) {
                $tag_ids[] = $tag->term_id;
            }
            $args = array(
                'tag__in' => $tag_ids,
                'post__not_in' => array_merge(array($post_id), wp_list_pluck($related_posts, 'ID')),
                'posts_per_page' => $number_of_posts - count($related_posts),
                'ignore_sticky_posts' => 1,
            );
            $more_related_posts = get_posts($args);
            $related_posts = array_merge($related_posts, $more_related_posts);
        }
    }

    return $related_posts;
}







function product_category_listing_shortcode($atts)
{
    ob_start();

    // Get all terms from services-category
    $terms = get_terms(array(
        'taxonomy' => 'services-category',
        'hide_empty' => false,
    ));

    // Filter only featured terms
    $featured_terms = array();
    if (!empty($terms) && !is_wp_error($terms)) {
        foreach ($terms as $term) {
            $is_featured = get_term_meta($term->term_id, 'featured', true);
            if (!empty($is_featured)) {
                $featured_terms[] = $term;
            }
        }
    }

    ?>
                <div class="services-category-featured">
                    <div class="services-category">
                        <div class="slick-services-category">
                            <?php if (!empty($featured_terms)):
                                foreach ($featured_terms as $term):
                                    $term_id = $term->term_id;
                                    $image_id = get_term_meta($term_id, 'category_image', true);
                                    $image_url = $image_id ? wp_get_attachment_image_url($image_id, 'full') : '';
                                    $link = get_term_link($term);
                                    ?>
                                    <div class="items">
                                        <div class="serives-category-box">

                                            <h3><?php echo esc_html($term->name); ?></h3>
                                            <?php if (!empty($term->description)): ?>
                                                <p><?php echo esc_html($term->description); ?></p>
                                            <?php endif; ?>
                                            <a href="<?php echo esc_url($link); ?>" class="btn-view-link">
                                                LEARN MORE
                                                <span>
                                                    <svg class="e-font-icon-svg e-fas-arrow-right" viewBox="0 0 448 512"
                                                        xmlns="http://www.w3.org/2000/svg">
                                                        <path
                                                            d="M190.5 66.9l22.2-22.2c9.4-9.4 24.6-9.4 33.9 0L441 239c9.4 9.4 9.4 24.6 0 33.9L246.6 467.3c-9.4 9.4-24.6 9.4-33.9 0l-22.2-22.2c-9.5-9.5-9.3-25 .4-34.3L311.4 296H24c-13.3 0-24-10.7-24-24v-32c0-13.3 10.7-24 24-24h287.4L190.9 101.2c-9.8-9.3-10-24.8-.4-34.3z">
                                                        </path>
                                                    </svg>
                                                </span>
                                            </a>

                                            <?php if ($image_url): ?>
                                                <img src="<?php echo esc_url($image_url); ?>"
                                                    alt="<?php echo esc_attr($term->name); ?>">
                                            <?php endif; ?>

                                        </div>
                                    </div>
                                <?php endforeach;
                            else:
                                echo '<p>No featured categories found.</p>';
                            endif; ?>
                        </div>
                    </div>
                    <script>
                        jQuery(document).ready(function ($) {
                            $(".slick-services-category").slick({
                                dots: false,
                                arrows: false,
                                infinite: true,
                                autoplay: false,
                                speed: 300,
                                slidesToShow: 2,
                                slidesToScroll: 1,
                                adaptiveHeight: true,
                                prevArrow: '<div class="left-btn arrowbtn"> <img src="http://localhost:8888/wp/Jin-yinmemorial/wp-content/uploads/2025/06/back.png"> </div>',
                                nextArrow: '<div class="right-btn arrowbtn"><img src="http://localhost:8888/wp/Jin-yinmemorial/wp-content/uploads/2025/06/back.png"></div>',
                                responsive: [{
                                    breakpoint: 1200,
                                    settings: {
                                        slidesToShow: 2,
                                        slidesToScroll: 1,
                                    },
                                },
                                {
                                    breakpoint: 1008,
                                    settings: {
                                        slidesToShow: 2,
                                        slidesToScroll: 1,
                                    },
                                },
                                {
                                    breakpoint: 800,
                                    settings: {
                                        slidesToShow: 1,
                                        slidesToScroll: 1,
                                    },
                                },
                                ],
                            });

                        });
                    </script>
                </div>
                <?php
                return ob_get_clean();
}
add_shortcode('services_category_list', 'product_category_listing_shortcode');




// user dashboard start ----------------------------------------------------------

function change_related_products_heading($translated_text, $text, $domain)
{
    if ('Related products' === $text) {
        $translated_text = __('Similar Products', 'your-text-domain');
    }
    return $translated_text;
}
add_filter('gettext', 'change_related_products_heading', 20, 3);


// product-categories start ----------------------------------------- 
function wpb_woocommerce_product_categories_accordion()
{
    // Get the current queried product category
    $queried_object = get_queried_object();
    $current_category_id = ($queried_object && isset($queried_object->term_id)) ? $queried_object->term_id : 0;

    // Get all parent categories of the current category
    $current_category_parents = [];
    if ($current_category_id) {
        $parent_categories = get_ancestors($current_category_id, 'product_cat');
        $current_category_parents = array_map('intval', $parent_categories);
    }

    // Recursive function to get subcategories with checkboxes
    function get_subcategories($parent_id, $level = 1, $current_category_id, $current_category_parents)
    {
        $args = array(
            'taxonomy' => 'product_cat',
            'orderby' => 'name',
            'order' => 'ASC',
            'parent' => $parent_id,
            'hide_empty' => true
        );
        $sub_categories = get_terms($args);

        if (!empty($sub_categories)) {
            echo '<ul class="list-unstyled ps-2">';
            foreach ($sub_categories as $sub_category) {
                $is_checked = ($sub_category->term_id == $current_category_id) ? 'checked' : '';
                $active_class = ($sub_category->term_id == $current_category_id) ? 'current-category' : '';

                echo '<li class="' . $active_class . '">';
                echo '<div class="in-menu">';
                echo '<input type="checkbox" class="category-checkbox me-2" data-category-id="' . $sub_category->term_id . '" ' . $is_checked . '> ';

                echo '<a href="' . get_term_link($sub_category) . '">  <span class="customcheck"></span>' . $sub_category->name . '</a>';
                echo '</div>';
                get_subcategories($sub_category->term_id, $level + 1, $current_category_id, $current_category_parents);
                echo '</li>';
            }
            echo '</ul>';
        }
    }

    // Get main product categories (parent categories)
    $args = array(
        'taxonomy' => 'product_cat',
        'orderby' => 'name',
        'order' => 'ASC',
        'parent' => 0,
        'hide_empty' => true
    );
    $product_categories = get_terms($args);

    if ($product_categories) {
        ob_start();
        ?>
                    <div class="accordion" id="productCategoriesAccordion">

                        <?php
                        $shop_page_url = wc_get_page_permalink('shop');
                        $is_shop_page = is_shop();
                        ?>

                        <div class="accordion-item">
                            <div class="accordion-header <?php echo $is_shop_page ? 'current-category' : ''; ?>">
                                <label>
                                    <a href="<?php echo esc_url($shop_page_url); ?>" class="main-category">
                                        All 
                                    </a>
                                </label>
                            </div>
                        </div>


                        <?php
                        $i = 0;
                        foreach ($product_categories as $category) {
                            $i++;

                            // Check if the category has subcategories
                            $sub_args = array(
                                'taxonomy' => 'product_cat',
                                'parent' => $category->term_id,
                                'hide_empty' => true
                            );
                            $sub_categories = get_terms($sub_args);
                            $has_subcategories = !empty($sub_categories);

                            // Determine if this category should be expanded
                            $is_checked = ($category->term_id == $current_category_id) ? 'checked' : '';
                            $active_class = ($category->term_id == $current_category_id || in_array($category->term_id, $current_category_parents)) ? 'current-category' : '';
                            $show_collapse = ($category->term_id == $current_category_id || in_array($category->term_id, $current_category_parents)) ? 'show' : '';
                            ?>
                            <div class="accordion-item <?php echo $active_class; ?>">
                                <div class="accordion-header d-flex align-items-center" id="heading<?php echo $i; ?>">
                                    <label for="cat<?php echo $category->term_id; ?>">
                                        <input type="checkbox" class="category-checkbox me-2"
                                            id="cat<?php echo $category->term_id; ?>"
                                            data-category-id="<?php echo $category->term_id; ?>" <?php echo $is_checked; ?>>

                                        <a href="<?php echo get_term_link($category); ?>" class="main-category">
                                            <span class="customcheck"></span> <?php echo $category->name; ?>
                                        </a>
                                    </label>

                                    <?php if ($has_subcategories) { ?>
                                        <button
                                            class="accordion-button ms-auto <?php echo ($show_collapse == '') ? 'collapsed' : ''; ?>"
                                            type="button" data-bs-toggle="collapse" data-bs-target="#collapse<?php echo $i; ?>"
                                            aria-expanded="<?php echo ($show_collapse) ? 'true' : 'false'; ?>"
                                            aria-controls="collapse<?php echo $i; ?>"
                                            data-category-id="<?php echo $category->term_id; ?>">
                                            <i class="fa fa-angle-down"></i>
                                        </button>
                                    <?php } ?>
                                </div>
                                <?php if ($has_subcategories) { ?>
                                    <div id="collapse<?php echo $i; ?>"
                                        class="accordion-collapse collapse <?php echo $show_collapse; ?>"
                                        aria-labelledby="heading<?php echo $i; ?>" data-bs-parent="#productCategoriesAccordion">
                                        <div class="accordion-body ps-0 pe-0">
                                            <?php get_subcategories($category->term_id, 1, $current_category_id, $current_category_parents); ?>
                                        </div>
                                    </div>
                                <?php } ?>
                            </div>
                            <?php
                        }
                        ?>
                    </div>

                    <script>
                        document.addEventListener("DOMContentLoaded", function () {
                            var savedCategories = JSON.parse(localStorage.getItem("checkedCategories")) || [];

                            savedCategories.forEach(function (categoryId) {
                                var checkbox = document.querySelector('.category-checkbox[data-category-id="' + categoryId + '"]');
                                if (checkbox) {
                                    checkbox.checked = true;
                                }
                            });

                            document.querySelectorAll(".category-checkbox").forEach(function (checkbox) {
                                checkbox.addEventListener("change", function () {
                                    var categoryId = this.getAttribute("data-category-id");
                                    if (this.checked) {
                                        if (!savedCategories.includes(categoryId)) {
                                            savedCategories.push(categoryId);
                                        }
                                    } else {
                                        savedCategories = savedCategories.filter(id => id !== categoryId);
                                    }
                                    localStorage.setItem("checkedCategories", JSON.stringify(savedCategories));
                                });
                            });

                            var activeCategory = localStorage.getItem("activeCategory");
                            if (activeCategory) {
                                var activeAccordion = document.querySelector('[data-category-id="' + activeCategory + '"]');
                                if (activeAccordion) {
                                    var collapseElement = activeAccordion.getAttribute("data-bs-target");
                                    document.querySelector(collapseElement).classList.add("show");
                                    activeAccordion.classList.remove("collapsed");
                                    activeAccordion.setAttribute("aria-expanded", "true");
                                }
                            }

                            document.querySelectorAll(".accordion-button").forEach(function (button) {
                                button.addEventListener("click", function () {
                                    var categoryId = this.getAttribute("data-category-id");
                                    if (document.querySelector(this.getAttribute("data-bs-target")).classList.contains("show")) {
                                        localStorage.removeItem("activeCategory");
                                    } else {
                                        localStorage.setItem("activeCategory", categoryId);
                                    }
                                });
                            });
                        });
                    </script>

                    <style>
                        .current-category>a {
                            font-weight: bold;
                            color: #ff6600;
                        }

                        .category-checkbox {
                            display: none;
                        }

                        span.customcheck {
                            background: #FFFFFF 0% 0% no-repeat padding-box;
                            border: 1px solid #B7DBEE;
                            border-radius: 5px;
                            width: 15px;
                            height: 15px;
                            position: relative;
                            margin-right: 6px;
                            margin-top: 0px;
                            top: 2px;
                            display: none;
                        }

                        .current-category [type=checkbox]:checked~a span.customcheck {
                            background: #326783;
                            border-color: #326783;
                        }

                        .current-category [type=checkbox]~a .customcheck:after {
                            content: "";
                            position: absolute;
                        }

                        .current-category a input:checked~.customcheck:after {
                            display: block;
                        }

                        .current-category a .customcheck:after {
                            left: 5px;
                            top: 2px;
                            width: 4px;
                            height: 8px;
                            border: solid white;
                            border-width: 0 2px 2px 0;
                            -webkit-transform: rotate(45deg);
                            -ms-transform: rotate(45deg);
                            transform: rotate(45deg);
                        }
                    </style>
                    <?php
                    return ob_get_clean();
    }
}

add_shortcode('product_categories_accordion', 'wpb_woocommerce_product_categories_accordion');

// product category for sidebar end -------------------------------






// Add custom quantity buttons JS start

add_action('wp_footer', 'custom_quantity_buttons_script');
function custom_quantity_buttons_script()
{
    if (!is_product())
        return;
    ?>
                <script>
                    document.addEventListener('DOMContentLoaded', function () {
                        const qtyContainers = document.querySelectorAll('.quantity');
                        qtyContainers.forEach(qty => {
                            const input = qty.querySelector('input.qty');
                            if (!input) return;

                            // Remove existing buttons (if any)
                            if (qty.querySelector('.custom-plus')) return;

                            // Create buttons
                            const minus = document.createElement('button');
                            minus.type = 'button';
                            minus.innerHTML = '−';
                            minus.className = 'custom-minus';

                            const plus = document.createElement('button');
                            plus.type = 'button';
                            plus.innerHTML = '+';
                            plus.className = 'custom-plus';

                            // Insert buttons
                            qty.insertBefore(minus, input);
                            qty.appendChild(plus);

                            // Event listeners
                            minus.addEventListener('click', () => {
                                if (input.value > 1) input.value = parseInt(input.value) - 1;
                            });
                            plus.addEventListener('click', () => {
                                input.value = parseInt(input.value) + 1;
                            });
                        });
                    });
                </script>
                <?php
}

// Add custom quantity buttons JS end

// shop header add start ---------------------------

add_action('woocommerce_before_main_content', 'custom_shop_header', 5);
function custom_shop_header()
{
    if (is_product()) {
        ?>
        <?php echo do_shortcode("[hfe_template id='1408']"); ?>
        <?php
    }
}
// shop header add end ---------------------------