<?php
/**
 * Template Name: Product Categories Listing
 */

get_header(); ?>
<?php echo do_shortcode('[hfe_template id="1408"]'); ?>

<section class="product-category-listing">
    <div class="container">
        <div class="row g-md-4">
            <?php
            $paged = get_query_var('paged') ? get_query_var('paged') : 1;
            $terms_per_page = 12; // Adjust per page count
            $offset = ($paged - 1) * $terms_per_page;


            $total_terms = count(get_terms(array(
                'taxonomy' => 'products-category',
                'hide_empty' => false,
                'parent' => 0,
                'fields' => 'ids'
            )));

            $terms = get_terms(array(
                'taxonomy' => 'products-category',
                'hide_empty' => false,
                'parent' => 0,
                'offset' => $offset,
                'number' => $terms_per_page,
            ));

            if (!empty($terms) && !is_wp_error($terms)):
                foreach ($terms as $term):
                    $term_id = $term->term_id;
                    $image_id = get_term_meta($term_id, 'category_image', 'products-category');
                    $image_url = $image_id ? wp_get_attachment_image_url($image_id, 'full') : '';
                    $link = get_term_link($term);
                    ?>
                    <div class="col-md-4 mb-3">
                        <div class="products-category-box">
                            <?php if ($image_url): ?>
                                <img src="<?php echo esc_url($image_url); ?>" alt="<?php echo esc_attr($term->name); ?>">
                            <?php endif; ?>
                            <h3><?php echo esc_html($term->name); ?></h3>
                            <?php if (!empty($term->description)): ?>
                                <p><?php echo esc_html($term->description); ?></p>
                            <?php endif; ?>

                            <a href="<?php echo esc_url($link); ?>" class="btn-view-link">
                                VIEW PRODUCT
                                <span> <svg class="e-font-icon-svg e-fas-arrow-right" viewBox="0 0 448 512"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <path
                                            d="M190.5 66.9l22.2-22.2c9.4-9.4 24.6-9.4 33.9 0L441 239c9.4 9.4 9.4 24.6 0 33.9L246.6 467.3c-9.4 9.4-24.6 9.4-33.9 0l-22.2-22.2c-9.5-9.5-9.3-25 .4-34.3L311.4 296H24c-13.3 0-24-10.7-24-24v-32c0-13.3 10.7-24 24-24h287.4L190.9 101.2c-9.8-9.3-10-24.8-.4-34.3z">
                                        </path>
                                    </svg></span></a>
                        </div>
                    </div>
                    <?php
                endforeach;
            else:
                echo '<p>No categories found.</p>';
            endif;
            ?>
        </div>
        <!-- PAGINATION -->
        <?php
        $total_pages = ceil($total_terms / $terms_per_page);
        if ($total_pages > 1): ?>
            <div class="pagination-center text-center mt-md-5 mt-3 mb-3">
                <div class="pagination-two">
                    <?php
                    echo paginate_links(array(
                        'base' => get_pagenum_link(1) . '%_%',
                        'format' => '/page/%#%/',
                        'current' => $paged,
                        'total' => $total_pages,
                        'prev_text' => '<i class="eicon-chevron-left"></i>',
                        'next_text' => '<i class="eicon-chevron-right"></i>',
                    ));
                    ?>
                </div>
            </div>
        <?php endif; ?>
    </div>
</section>

<?php get_footer(); ?>