<?php get_header(); ?>

<?php echo do_shortcode('[hfe_template id="1408"]'); ?>

<div class="single-eproduct">

    <div class="container">
        <?php
        if (have_posts()):
            while (have_posts()):
                the_post();
        ?>
                <div class="row g-md-5 g-3 justify-content-between">

                    <div class="col-md-6">
                        <div class="img-wrap">
                            <?php if (has_post_thumbnail()) {
                                the_post_thumbnail('full', array('class' => 'd-block w-100'));
                            } ?>
                        </div>
                        <div class="catalogs_wrap">
                            <div class="">
                                <h4>Catalogs</h4>
                            </div>

                            <?php $pdf_url = get_field('pdf');
                            ?>
                            <?php if (!empty($pdf_url)): ?>
                                <div class="wrap">
                                    <a href="<?php echo esc_url($pdf_url); ?>" class="elementor-button" target="_blank">
                                        DOWNLOAD CATALOGUE
                                    </a>
                                </div>
                            <?php endif; ?>


                        </div>
                    </div>

                    <div class="col-md-6">
                        <h6 class="sub-title"> PRODUCTS </h6>
                        <h2 class="title"><?php echo the_title(); ?></h2>
                        <div class="content-area">
                            <?php the_content(); ?>
                        </div>
                    </div>
                </div>


                <div class="row justify-content-center pt-md-4">
                    <div class="col-md-12 col-sm-12 col-12 mt-md-5 mt-4">

                        <?php
                        $gallery_image = get_field('gallery_image', get_the_ID());

                        if (!empty($gallery_image)): ?>

                            <h2 class="title-two mb-4">Gallery</h2>
                            <div class="project-slider">
                                <div class="slick-slider-portfolio">
                                    <?php foreach ($gallery_image as $row):
                                        $image_url = $row['image']; // Direct image URL if return format is 'URL'
                                        if (!empty($image_url)): ?>
                                            <div class="item ps-2 pe-2">
                                                <div class="img-wraps">
                                                    <img src="<?php echo esc_url($image_url); ?>" alt="" class="w-100">
                                                </div>
                                            </div>
                                    <?php endif;
                                    endforeach; ?>
                                </div>
                            </div>
                        <?php endif; ?>


                    </div>
                </div>

                <div class="row justify-content-center pt-md-4">
                    <div class="col-md-12 col-sm-12 col-12 mt-md-5 mt-4">

                        <?php echo do_shortcode('[hfe_template id="3079"]'); ?>
                    </div>
                </div>

                <div class="row justify-content-center pt-md-4">

                    <?php
                    $product_showcase = get_field('product_showcase');

                    if (!empty($product_showcase)): ?>
                        <div class="col-md-12 col-sm-12 col-12 mt-md-5 mt-4">
                            <h2 class="title-two mb-4">Product Showcase</h2>
                        </div>
                        <?php foreach ($product_showcase as $item):
                            $image_id = $item['showcase_image'];
                            $image_url = $image_id ? wp_get_attachment_image_url($image_id, 'full') : '';
                            $title = $item['title'];
                            $description = $item['description'];
                        ?>
                            <div class="col-md-12 col-sm-12 col-12 mb-4 product-showcase">
                                <div class="row g-0 justify-content-center">
                                    <div class="col-md-6">
                                        <div class="img-wraps">
                                            <?php if ($image_url): ?>
                                                <img src="<?php echo esc_url($image_url); ?>" alt="<?php echo esc_attr($title); ?>">
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="content-wraps">
                                            <div>
                                                <?php if (!empty($title)): ?>
                                                    <h2><?php echo esc_html($title); ?></h2>
                                                <?php endif; ?>
                                                <?php if (!empty($description)): ?>
                                                    <p><?php echo esc_html($description); ?></p>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; ?>
                </div>
            <?php endif; ?>


    </div>
</div>


<?php
            endwhile;
        else:
            echo 'No post found.';
        endif;
?>

</div>

</div>


<script>
    jQuery(document).ready(function($) {
        $(".slick-slider-portfolio").slick({
            dots: true,
            arrows: false,
            infinite: true,
            speed: 300,
            slidesToShow: 3,
            slidesToScroll: 1,
            adaptiveHeight: true,
            prevArrow: '<div class="left-btn arrowbtn"><i class="eicon-chevron-left"></i></div>',
            nextArrow: '<div class="right-btn arrowbtn"><i class="eicon-chevron-right"></i></div>',
            responsive: [{
                    breakpoint: 1200,
                    settings: {
                        slidesToShow: 3,
                        slidesToScroll: 1,
                    },
                },
                {
                    breakpoint: 1008,
                    settings: {
                        slidesToShow: 3,
                        slidesToScroll: 1,
                    },
                },
                {
                    breakpoint: 800,
                    settings: {
                        slidesToShow: 1,
                        slidesToScroll: 1,
                    },
                },
            ],
        });

    });
</script>

<?php get_footer(); ?>