<?php get_header(); ?>

<?php
$terms = get_the_terms(get_the_ID(), 'services-category');

$term = !empty($terms) && !is_wp_error($terms) ? $terms[0] : null;
$image_url = '';

if ($term) {
    $banner_image = get_field('banner_image', $term);
    if (!empty($banner_image)) {
        $image_url = wp_get_attachment_image_url($banner_image, 'full');
    }
}
?>

<div class="banner-custom" style="background-image: url('<?php echo esc_url($image_url); ?>');">
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <?php if ($term): ?>
                    <h5><?php echo esc_html($term->name); ?></h5>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>


<div class="single-detail">

    <div class="container">
        <?php
        if (have_posts()):
            while (have_posts()):
                the_post();
                ?>
                <div class="row g-md-5 g-3 justify-content-between">

                    <div class="col-md-6">
                        <div class="img-wrap">
                            <?php if (has_post_thumbnail()) {
                                the_post_thumbnail('full', array('class' => 'd-block w-100'));
                            } ?>
                        </div>
                    </div>

                    <div class="col-md-6">


                        <?php
                        $terms = get_the_terms(get_the_ID(), 'services-category');

                        if (!empty($terms) && !is_wp_error($terms)) {
                            $child_term = null;

                            foreach ($terms as $term) {
                                if ($term->parent != 0) {
                                    $child_term = $term;
                                    break;
                                }
                            }

                            if ($child_term) {
                                echo '<h6 class="sub-title">' . esc_html($child_term->name) . '</h6>';
                            }
                            // else {
                            //     echo '<h6 class="sub-title">No child category found</h6>';
                            // }
                        }
                        ?>








                        <h2 class="title"><?php echo the_title(); ?></h2>

                        <div class="content-area">
                            <?php the_content(); ?>
                        </div>
                        <div class="btn-area pt-2">
                            <a href="javascript:viod(0)" class="elementor-button theme-btn-custom popmake-2618">
                                ENQUIRE NOW
                            </a>
                        </div>


                    </div>
                </div>



                <?php
                $area_of_expertise = get_field('area_of_expertise');

                if (!empty($area_of_expertise)):
                    ?>
                    <div class="row justify-content-center pt-md-4">
                        <div class="col-md-12 col-sm-12 col-12 mt-md-5 mt-4">
                            <h2 class="title-two text-start mb-4">Area of Expertise</h2>
                            <ol class="count-area-list">
                                <?php foreach ($area_of_expertise as $item): ?>
                                    <li>
                                        <div class="wrap-two">
                                            <h5><?php echo esc_html($item['area_title']); ?></h5>
                                            <p><?php echo esc_html($item['area_description']); ?></p>
                                        </div>
                                    </li>
                                <?php endforeach; ?>
                            </ol>
                        </div>
                    </div>
                <?php endif; ?>




                <div class="row justify-content-center pt-md-4">
                    <div class="col-md-12 col-sm-12 col-12 mt-md-5 mt-4">

                        <?php
                        $gallery_image = get_field('gallery_image', get_the_ID());

                        if (!empty($gallery_image)): ?>

                            <h2 class="title-two mb-4">Gallery</h2>
                            <div class="project-slider">
                                <div class="slick-slider-portfolio">
                                    <?php foreach ($gallery_image as $row):
                                        $image_url = $row['image']; // Direct image URL if return format is 'URL'
                                        if (!empty($image_url)): ?>
                                            <div class="item ps-2 pe-2">
                                                <div class="img-wraps">
                                                    <img src="<?php echo esc_url($image_url); ?>" alt="" class="w-100">
                                                </div>
                                            </div>
                                        <?php endif;
                                    endforeach; ?>
                                </div>
                            </div>
                        <?php endif; ?>


                    </div>
                </div>


              


                <?php
            endwhile;
        else:
            echo 'No post found.';
        endif;
        ?>

    </div>

</div>


<script>
    jQuery(document).ready(function ($) {
        $(".slick-slider-portfolio").slick({
            dots: true,
            arrows: false,
            infinite: true,
            speed: 300,
            slidesToShow: 3,
            slidesToScroll: 1,
            adaptiveHeight: true,
            prevArrow: '<div class="left-btn arrowbtn"><i class="eicon-chevron-left"></i></div>',
            nextArrow: '<div class="right-btn arrowbtn"><i class="eicon-chevron-right"></i></div>',
            responsive: [{
                breakpoint: 1200,
                settings: {
                    slidesToShow: 3,
                    slidesToScroll: 1,
                },
            },
            {
                breakpoint: 1008,
                settings: {
                    slidesToShow: 3,
                    slidesToScroll: 1,
                },
            },
            {
                breakpoint: 800,
                settings: {
                    slidesToShow: 1,
                    slidesToScroll: 1,
                },
            },
            ],
        });

    });
</script>

<?php get_footer(); ?>