<?php get_header(); ?>


<?php echo do_shortcode('[hfe_template id="2303"]'); ?>
<div class="single-detail">

    <div class="container">
        <?php
        if (have_posts()):
            while (have_posts()):
                the_post();
                ?>
                <div class="row g-md-5 g-3 justify-content-between">

                    <div class="col-md-6">
                        <div class="img-wrap">
                            <?php if (has_post_thumbnail()) {
                                the_post_thumbnail('full', array('class' => 'd-block w-100'));
                            } ?>
                        </div>
                    </div>

                    <div class="col-md-6">
                        <h6 class="sub-title">Training</h6>
                        <h2 class="title"><?php echo the_title(); ?></h2>

                        <div class="content-area">
                            <?php the_content(); ?>
                        </div>

                    </div>
                </div>

                <div class="row justify-content-center pt-md-4">
                    <div class="col-md-12 col-sm-12 col-12 mt-md-5 mt-4">

                        <?php
                        $training_images = get_field('training_images', get_the_ID());

                        if (!empty($training_images)): ?>
                            <div class="project-slider">
                                <div class="slick-slider-training">
                                    <?php foreach ($training_images as $row):
                                        $image_url = $row['image']; // Direct image URL if return format is 'URL'
                                        if (!empty($image_url)): ?>
                                            <div class="item ps-2 pe-2">
                                                <div class="img-wraps">
                                                    <img src="<?php echo esc_url($image_url); ?>" alt="" class="w-100">
                                                </div>
                                            </div>
                                        <?php endif;
                                    endforeach; ?>
                                </div>
                            </div>
                        <?php endif; ?>


                    </div>
                </div>


                <?php
            endwhile;
        else:
            echo 'No post found.';
        endif;
        ?>

    </div>

</div>


<script>
    jQuery(document).ready(function ($) {
        $(".slick-slider-training").slick({
            dots: true,
            arrows:false,
            infinite: true,
            speed: 300,
            slidesToShow: 3,
            slidesToScroll: 1,
            adaptiveHeight: true,
            prevArrow: '<div class="left-btn arrowbtn"><i class="eicon-chevron-left"></i></div>',
            nextArrow: '<div class="right-btn arrowbtn"><i class="eicon-chevron-right"></i></div>',
            responsive: [{
                breakpoint: 1200,
                settings: {
                    slidesToShow: 3,
                    slidesToScroll: 1,
                },
            },
            {
                breakpoint: 1008,
                settings: {
                    slidesToShow: 3,
                    slidesToScroll: 1,
                },
            },
            {
                breakpoint: 800,
                settings: {
                    slidesToShow: 1,
                    slidesToScroll: 1,
                },
            },
            ],
        });

    });
</script>

<?php get_footer(); ?>