<?php get_header(); ?>
<?php echo '<!-- taxonomy-products-category.php is active -->'; ?>

<?php echo do_shortcode('[hfe_template id="1408"]'); ?>





<section class="category-header">
    <div class="container">
        <div class="row g-md-5 g-3 justify-content-between">
            <div class="col-md-6">
                <div class="img-wrap">
                    <?php
                    $term = get_queried_object();
                    $term_id = $term->term_id;

                    // Get SCF image (return format: ID)
                    $image_id = get_term_meta($term_id, 'category_image', 'products-category');
                    $image_url = $image_id ? wp_get_attachment_image_url($image_id, 'large') : '';
                    ?>
                    <?php if ($image_url): ?>
                        <img src="<?php echo esc_url($image_url); ?>" alt="<?php echo esc_attr($term->name); ?>"
                            style="width:100%; height:auto;">
                    <?php endif; ?>
                </div>
            </div>
            <div class="col-md-6">

                <h6 class="sub-title">PRODUCTS</h6>

                <h2><?php echo esc_html($term->name); ?></h2>
                <?php if (!empty($term->description)): ?>
                    <p><?php echo esc_html($term->description); ?></p>
                <?php endif; ?>
            </div>
        </div>
    </div>
</section>


<section class="child-category-listing">
    <div class="container">
        <div class="row">
            <?php
            $child_terms = get_terms(array(
                'taxonomy' => 'products-category',
                'hide_empty' => false,
                'parent' => $term_id,
            ));

            if (!empty($child_terms) && !is_wp_error($child_terms)):
                foreach ($child_terms as $child):
                    $child_id = $child->term_id;
                    $child_image_id = get_term_meta($child_id, 'category_image', true); // true for single value
                    $child_image_url = $child_image_id ? wp_get_attachment_image_url($child_image_id, 'full') : '';
                    $child_link = get_term_link($child);
                    ?>
                    <div class="category-list-box">
                        <div class="row gx-md-0">
                            <div class="col-md-5">
                                <a href="<?php echo esc_url($child_link); ?>">
                                    <?php if ($child_image_url): ?>
                                        <img src="<?php echo esc_url($child_image_url); ?>"
                                            alt="<?php echo esc_attr($child->name); ?>">
                                    <?php endif; ?>
                                </a>
                            </div>
                            <div class="col-md-7">
                                <div class="wrap-content">
                                    <div>
                                        <h3><?php echo esc_html($child->name); ?></h3>
                                        <?php if (!empty($child->description)): ?>
                                            <p><?php echo esc_html($child->description); ?></p>
                                        <?php endif; ?>

                                        <a href="<?php echo esc_url($child_link); ?>" class="btn-view-link text-white">
                                            VIEW PRODUCT
                                            <span> <svg class="e-font-icon-svg e-fas-arrow-right" viewBox="0 0 448 512"
                                                    xmlns="http://www.w3.org/2000/svg">
                                                    <path
                                                        d="M190.5 66.9l22.2-22.2c9.4-9.4 24.6-9.4 33.9 0L441 239c9.4 9.4 9.4 24.6 0 33.9L246.6 467.3c-9.4 9.4-24.6 9.4-33.9 0l-22.2-22.2c-9.5-9.5-9.3-25 .4-34.3L311.4 296H24c-13.3 0-24-10.7-24-24v-32c0-13.3 10.7-24 24-24h287.4L190.9 101.2c-9.8-9.3-10-24.8-.4-34.3z">
                                                    </path>
                                                </svg></span></a>

                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach;
            else: ?>




                <div class="container">
                    <?php
                    $paged = (get_query_var('paged')) ? get_query_var('paged') : 1; 

                    $term = get_queried_object();

                    $args = array(
                        'post_type' => 'eproducts',
                        'posts_per_page' => 8, 
                        'paged' => $paged,
                        'tax_query' => array(
                            array(
                                'taxonomy' => 'products-category',
                                'field' => 'slug',
                                'terms' => $term->slug,
                            ),
                        ),
                    );

                    $product_query = new WP_Query($args);

                    if ($product_query->have_posts()):
                        echo '<div class="row">';
                        echo '<div class="col-md-12">';
                        echo '<div class="title-top">';
                        echo '<h2 class="title">' . esc_html($term->name) . '</h2>';
                        echo '</div></div></div>';

                        echo '<div class="row g-md-3">';
                        while ($product_query->have_posts()):
                            $product_query->the_post(); ?>
                            <div class="col-md-3 mb-4">
                                <div class="products-catalogue">
                                    <div class="img-wrap">
                                        <?php the_post_thumbnail('full'); ?>
                                        <div class="catalogue">
                                            <a href="<?php the_permalink(); ?>" class="elementor-button">
                                                DOWNLOAD CATALOGUE
                                            </a>
                                        </div>

                                        
                                    </div>
                                    <h4><?php the_title(); ?></h4>
                                </div>
                            </div>
                        <?php endwhile;
                        echo '</div>'; // .row
                
                        // ✅ Pagination
                        $total_pages = $product_query->max_num_pages;
                        if ($total_pages > 1) {
                            echo '<div class="pagination-center text-center mt-5">';
                            echo paginate_links(array(
                                'current' => max(1, $paged),
                                'total' => $total_pages,
                                'prev_text' => '<i class="eicon-chevron-left"></i>',
                                'next_text' => '<i class="eicon-chevron-right"></i>',
                            ));
                            echo '</div>';
                        }

                        wp_reset_postdata();
                    else:
                        echo '<p>No products found in this category.</p>';
                    endif;
                    ?>
                </div>









            <?php endif; ?>

        </div>


    </div>
    </div>
</section>



<?php get_footer(); ?>