<?php get_header(); ?>

<?php
$term = get_queried_object();
$banner_image = get_field('banner_image', $term);
$image_url = '';

if (!empty($banner_image)) {
    $image_url = wp_get_attachment_image_url($banner_image, 'full');
}
?>

<div class="banner-custom" style="background-image: url('<?php echo esc_url($image_url); ?>');">
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <h5>Service</h5>
            </div>
        </div>
    </div>
</div>

<div class="service-taxonomy">
    <div class="container">
        <div class="category-section">
            <div class="row g-md-5 g-3 justify-content-between">
                <div class="col-md-4">
                    <h6 class="sub-title">SERVICES</h6>
                    <h2 class="title"><?php echo esc_html($term->name); ?></h2>
                </div>
                <div class="col-md-8">
                    <?php
                    $term_desc = term_description($term->term_id, 'services-category');
                    if (!empty($term_desc)) {
                        echo '<div class="term-description">' . $term_desc . '</div>';
                    }
                    ?>
                </div>
            </div>
        </div>

        <?php
        global $wp_query; // Use main query for pagination to work
        if ($wp_query->have_posts()): ?>
            <div class="service-section">
                <div class="row g-md-5 g-3 justify-content-between">
                    <?php while ($wp_query->have_posts()): $wp_query->the_post(); ?>
                        <div class="col-md-6">
                            <div class="service-box">
                                <a href="<?php the_permalink(); ?>" class="d-block">
                                    <div class="img-wrap">
                                        <?php
                                        if (has_post_thumbnail()) {
                                            the_post_thumbnail('full', ['class' => 'd-block w-100']);
                                        }
                                        ?>
                                    </div>
                                    <h2 class="title"><?php the_title(); ?></h2>
                                </a>
                            </div>
                        </div>
                    <?php endwhile; ?>
                </div>

                <?php
                // Pagination
                if ($wp_query->max_num_pages > 1): ?>
                    <div class="pagination-center text-center mt-md-5 mt-3 mb-3">
                        <div class="pagination-two">
                            <?php
                            echo paginate_links([
                                'base' => get_pagenum_link(1) . '%_%',
                                'format' => 'page/%#%/',
                                'current' => max(1, get_query_var('paged')),
                                'total' => $wp_query->max_num_pages,
                                'prev_text' => '<i class="eicon-chevron-left"></i>',
                                'next_text' => '<i class="eicon-chevron-right"></i>',
                                'end_size' => 2,
                                'mid_size' => 2,
                            ]);
                            ?>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        <?php else: ?>
            <p>No services found in this category.</p>
        <?php endif; ?>

        <?php wp_reset_postdata(); ?>
    </div>
</div>

<?php get_footer(); ?>
