<?php
// Enqueue the parent theme's stylesheet

function hello_elementor_child_enqueue_styles()
{
    wp_enqueue_style('hello-elementor-parent-style', get_template_directory_uri() . '/../hello-elementor-child/style.css');
}
add_action('wp_enqueue_scripts', 'hello_elementor_child_enqueue_styles');



// Enqueue Booststrap 
function enqueue_bootstrap()
{
    wp_enqueue_style('bootstrap-css', 'https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css');
    wp_enqueue_script('bootstrap-js', 'https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.min.js', array('jquery'), null, true);
}
add_action('wp_enqueue_scripts', 'enqueue_bootstrap');


//  Slick carousel script and styles
function add_slick_slider_assets()
{
    // Slick Slider CSS
    wp_enqueue_style('slick-css', 'https://cdn.jsdelivr.net/npm/slick-carousel/slick/slick.css');
    wp_enqueue_style('slick-theme-css', 'https://cdn.jsdelivr.net/npm/slick-carousel/slick/slick-theme.css');
    wp_enqueue_script('slick-js', 'https://cdn.jsdelivr.net/npm/slick-carousel/slick/slick.min.js', array('jquery'), '', true);
    wp_enqueue_script('hello-elementor-parent-js', get_template_directory_uri() . '/../hello-elementor-child/custom.js');
}
add_action('wp_enqueue_scripts', 'add_slick_slider_assets');



// custom code






// Home slider Start --------------------------------------------
function display_banner_home($atts)
{
    $args = array(
        'post_type' => 'main-slider',
    );

    $mainslider_query = new WP_Query($args);

    ob_start();

    if ($mainslider_query->have_posts()):
        $total_slides = $mainslider_query->post_count;
?>
        <div id="demo" class="carousel slide hero-banner" data-bs-ride="carousel">
            <div class="carousel-inner">
                <?php
                $first = true;
                while ($mainslider_query->have_posts()):
                    $mainslider_query->the_post(); ?>

                    <div class="carousel-item <?php echo $first ? 'active' : ''; ?>">

                        <div class="row align-items-center">
                            <div class="col-lg-4 col-md-6">
                                <h2><?php the_title(); ?></h2>
                                <p><?php the_content(); ?></p>

                                <?php
                                $links = get_field('button_link');
                                if ($links) {
                                    $link_url = $links['url'];
                                    $link_title = $links['title'];
                                ?>
                                    <a href="<?php echo esc_url($link_url); ?>"
                                        class="elementor-button"><?php echo esc_html($link_title); ?></a>
                                <?php } ?>


                            </div>
                            <div class="col-lg-8 col-md-6">
                                <?php if (has_post_thumbnail()) {
                                    the_post_thumbnail('full', array('class' => 'd-block w-100'));
                                } ?>
                            </div>
                        </div>
                    </div>

                <?php
                    $first = false;
                endwhile; ?>
            </div>
            <?php if ($total_slides > 1) { ?>
                <div class="carousel-indicators justify-content-start">
                    <?php for ($i = 0; $i < $total_slides; $i++): ?>
                        <button type="button" data-bs-target="#demo" data-bs-slide-to="<?php echo $i; ?>"
                            class="<?php echo $i === 0 ? 'active' : ''; ?>">
                        </button>
                    <?php endfor; ?>
                </div>
            <?php } ?>


            <script>
                document.addEventListener("DOMContentLoaded", function() {
                    var myCarousel = document.querySelector("#demo");
                    myCarousel.addEventListener("slid.bs.carousel", function(event) {
                        var activeIndex = event.to;
                        var indicators = document.querySelectorAll(".banner-indicators button");

                        indicators.forEach(function(btn, index) {
                            if (index === activeIndex) {
                                btn.classList.add("active");
                            } else {
                                btn.classList.remove("active");
                            }
                        });
                    });
                });
            </script>

        <?php else: ?>
            <div>No Slider found.</div>
        <?php endif;

    wp_reset_postdata();

    return ob_get_clean();
}
add_shortcode('banner_home', 'display_banner_home');


// Home slider end --------------------------------------------



// testimonials slider  start -----------------------------------------------------

function display_testimonials_slider($atts)
{
    // Attributes
    $atts = shortcode_atts(
        array(
            'posts_per_page' => 9,
        ),
        $atts,
        'testimonials'
    );

    $args = array(
        'post_type' => 'testimonials',
        'posts_per_page' => $atts['posts_per_page'],
    );

    $testimonials_query = new WP_Query($args);

    ob_start();

    if ($testimonials_query->have_posts()): ?>
            <div class="slick-slider testimonials-slider">
                <?php while ($testimonials_query->have_posts()):
                    $testimonials_query->the_post();
                ?>

                    <div>
                        <div class="testimonial-box">
                            <div class="row justify-content-between align-items-center">
                                <div class="col-lg-6 pe-lg-5">
                                    <div class="description description-limit mb-0">
                                        <?php the_content(); ?>
                                    </div>
                                    <div class="read-more-wrap">
                                        <?php
                                        $content = get_the_content();
                                        $word_count = str_word_count(wp_strip_all_tags(strip_shortcodes($content)));
                                        if ($word_count > 100):
                                        ?>
                                            <a class="read-more" data-bs-toggle="modal"
                                                data-bs-target="#exampleModal<?php echo get_the_ID(); ?>">
                                                Read More
                                            </a>
                                        <?php endif; ?>
                                    </div>
                                    <p class="author"><?php the_title(); ?></p>
                                </div>
                                <div class="col-lg-6 for-bg-img">
                                    <?php if (has_post_thumbnail()) {
                                        the_post_thumbnail('full', array('class' => 'd-block w-75 p-4 m-auto'));
                                    } ?>
                                </div>
                            </div>
                        </div>
                    </div>


                <?php endwhile; ?>
            </div>



            <?php while ($testimonials_query->have_posts()):
                $testimonials_query->the_post(); ?>



                <div class="modal fade" id="exampleModal<?php echo get_the_ID(); ?>" tabindex="-1"
                    aria-labelledby="exampleModalLabel" aria-hidden="true">
                    <small class="btn-close btn-close-white border-0" type="button" data-bs-dismiss="modal"></small>
                    <div class="modal-dialog modal-dialog-centered modal-lg">
                        <div class="modal-content bg-transparent border-0 rounded-0">
                            <div class="modal-body">
                                <div class="testimonial-box bg-transparent rounded-0 mb-0">
                                    <div class="description description-quote mb-4 text-white">
                                        <?php echo the_content(); ?>
                                    </div>
                                    <h6 class="author mb-0 text-white">
                                        <?php the_title(); ?>
                                    </h6>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>

            <?php endwhile; ?>



        <?php else:
        echo 'No testimonials found.';
    endif;

    wp_reset_postdata();

    return ob_get_clean();
}
add_shortcode('testimonials_slider', 'display_testimonials_slider');

// testimonials slider  end -----------------------------------------------------


// Testimonial page start ------------------------------------------------------------

function display_testimonials($atts)
{
    // Attributes
    $atts = shortcode_atts(
        array(
            'posts_per_page' => 3,
            'category' => isset($_GET['category']) ? sanitize_text_field($_GET['category']) : '',
        ),
        $atts,
        'testimonials'
    );


    $args = array(
        'post_type' => 'testimonials',
        'posts_per_page' => $atts['posts_per_page'],
        'paged' => get_query_var('paged') ? get_query_var('paged') : 1,
    );

    $testimonials_query = new WP_Query($args);

    ob_start();


    $count = 0;
    if ($testimonials_query->have_posts()): ?>
            <div class="testimonials-list">
                <?php while ($testimonials_query->have_posts()):
                    $testimonials_query->the_post();
                    $count++;
                    $flip_class = ($count % 2 == 0) ? 'flex-row-reverse' : '';
                ?>
                    <div>
                        <div class="testimonial-box">
                            <div class="row justify-content-between align-items-center <?php echo $flip_class; ?>">
                                <div class="col-lg-6 pe-lg-5">
                                    <div class="description description-limit mb-0">
                                        <?php the_content(); ?>
                                    </div>
                                    <div class="read-more-wrap">
                                        <?php
                                        $content = get_the_content();
                                        $word_count = str_word_count(wp_strip_all_tags(strip_shortcodes($content)));
                                        if ($word_count > 100):
                                        ?>
                                            <a class="read-more" data-bs-toggle="modal"
                                                data-bs-target="#exampleModal<?php echo get_the_ID(); ?>">
                                                Read More
                                            </a>
                                        <?php endif; ?>
                                    </div>
                                    <p class="author"><?php the_title(); ?></p>
                                </div>
                                <div class="col-lg-6 for-bg-img">

                                    <?php if (has_post_thumbnail()) {
                                        the_post_thumbnail('full', array('class' => 'd-block w-75 m-auto'));
                                    } ?>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endwhile; ?>
            </div>




            <?php while ($testimonials_query->have_posts()):
                $testimonials_query->the_post(); ?>
                <div class="modal fade" id="exampleModal<?php echo get_the_ID(); ?>" tabindex="-1"
                    aria-labelledby="exampleModalLabel" aria-hidden="true">
                    <small class="btn-close btn-close-white border-0" type="button" data-bs-dismiss="modal"></small>
                    <div class="modal-dialog modal-dialog-centered modal-lg">
                        <div class="modal-content bg-transparent border-0 rounded-0">
                            <div class="modal-body">
                                <div class="testimonial-box bg-transparent rounded-0 mb-0">
                                    <div class="description description-quote mb-4 text-white">
                                        <?php echo the_content(); ?>
                                    </div>
                                    <h6 class="author mb-0 text-white">
                                        <?php the_title(); ?>
                                    </h6>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endwhile; ?>


            <div class="pagination-center text-center mt-md-5 mt-3 mb-3">
                <div class="pagination-two d-inline-block">
                    <?php
                    echo paginate_links(
                        array(
                            'total' => $testimonials_query->max_num_pages,
                            'current' => max(1, get_query_var('paged')),
                            'format' => '?paged=%#%',
                            'show_all' => false,
                            'type' => 'plain',
                            'prev_text' => __('<img src="https://draftsite1.com/websentials-academy/wp-content/uploads/2025/03/arrow-left-circle-1.svg">'),
                            'next_text' => __('<img src="https://draftsite1.com/websentials-academy/wp-content/uploads/2025/03/arrow-right-circle.svg">'),
                            'end_size' => 2,
                            'mid_size' => 2
                        )
                    );
                    ?>
                </div>
            </div>

        <?php else:
        echo 'No testimonials found.';
    endif;

    wp_reset_postdata();

    return ob_get_clean();
}
add_shortcode('testimonials', 'display_testimonials');


// Testimonial page End ------------------------------------------------------------


// documents page start ------------------------------------------------------------

function display_documents($atts)
{
    // Attributes
    $atts = shortcode_atts(
        array(
            'posts_per_page' => 9,
            'category' => isset($_GET['category']) ? sanitize_text_field($_GET['category']) : '',
        ),
        $atts,
        'documents'
    );

    // Get the current page


    $args = array(
        'post_type' => 'documents',
        'posts_per_page' => $atts['posts_per_page'],
        'paged' => get_query_var('paged') ? get_query_var('paged') : 1,
    );


    // Filter by category if provided
    if (!empty($atts['category'])) {
        $args['tax_query'] = array(
            array(
                'taxonomy' => 'documents-category',
                'field' => 'slug',
                'terms' => $atts['category'],
            ),
        );
    }
    // Get categories
    $categories = get_terms(array(
        'taxonomy' => 'documents-category',
        'hide_empty' => true,
    ));

    if ($categories):
        ?>
            <div class="col-lg-12 mb-5">
                <ul id="category-filter-list" class="document-filter nav justify-content-center">

                    <li><a href="<?php echo esc_url(add_query_arg('category', '', home_url('/form-documents'))); ?>"
                            class="all-cat-head <?php echo empty($atts['category']) ? 'active' : ''; ?>"> All </a></li>
                    <?php foreach ($categories as $category):
                        $active_class = ($atts['category'] === $category->slug) ? 'active' : '';
                    ?>
                        <li>
                            <a href="<?php echo esc_url(add_query_arg('category', $category->slug, home_url('/form-documents'))); ?>"
                                class="cats <?php echo esc_attr($active_class); ?>">
                                <?php echo esc_html($category->name); ?>
                            </a>
                        </li>
                    <?php endforeach; ?>
                </ul>
            </div>
        <?php
    endif;




    $documents_query = new WP_Query($args);

    ob_start();

    if ($documents_query->have_posts()): ?>
            <div class="testimonial-page documents-main">
                <div class="row g-md-3 g-3">
                    <?php while ($documents_query->have_posts()):
                        $documents_query->the_post();

                        $document_url = get_post_meta(get_the_ID(), 'documents_file', true);
                        $document_url = get_field('documents_file');

                    ?>

                        <div class="col-lg-4 col-md-4 col-sm-6 mb-4">
                            <div class="document-box">
                                <a href="<?php echo esc_url($document_url); ?>" target="_blank">
                                    <div class="img-box text-center">
                                        <?php if (has_post_thumbnail()) {
                                            the_post_thumbnail('full', array('class' => 'img-fluid'));
                                        } ?>
                                    </div>
                                    <div class="text-box">
                                        <h5 class="title"><?php echo get_the_title(); ?></h5>
                                        <div class="description">
                                            <?php echo the_content(); ?>
                                        </div>
                                    </div>
                                </a>
                            </div>
                        </div>

                    <?php endwhile; ?>
                </div>
            </div>


            <script type="text/javascript">
                document.addEventListener('DOMContentLoaded', function() {
                    var listItems = document.querySelectorAll('#category-filter-list a');
                    listItems.forEach(function(item) {
                        item.addEventListener('click', function(event) {
                            // No need to prevent default here; the link's href handles the filtering
                        });
                    });
                });
            </script>

            <div class="pagination-center text-center mt-md-5 mt-3 mb-3">
                <div class="pagination-two d-inline-block">
                    <?php
                    echo paginate_links(
                        array(
                            'total' => $documents_query->max_num_pages,
                            'current' => max(1, get_query_var('paged')),
                            'format' => '?paged=%#%',
                            'show_all' => false,
                            'type' => 'plain',
                            'prev_text' => __('<img src="https://draftsite1.com/websentials-academy/wp-content/uploads/2025/03/arrow-left-circle-1.svg">'),
                            'next_text' => __('<img src="https://draftsite1.com/websentials-academy/wp-content/uploads/2025/03/arrow-right-circle.svg">'),
                            'end_size' => 2,
                            'mid_size' => 2
                        )
                    );
                    ?>
                </div>
            </div>

        <?php else:
        echo 'No documents found.';
    endif;

    wp_reset_postdata();

    return ob_get_clean();
}
add_shortcode('documents', 'display_documents');


// documents page End ------------------------------------------------------------

// courses slider  start -----------------------------------------------------

function display_courses_slider($atts)
{
    // Attributes
    $atts = shortcode_atts(
        array(
            'posts_per_page' => 9,
        ),
        $atts,
        'courses'
    );

    $args = array(
        'post_type' => 'courses',
        'posts_per_page' => $atts['posts_per_page'],
    );

    $courses_query = new WP_Query($args);

    ob_start();

    if ($courses_query->have_posts()): ?>
            <div class="slick-slider course-slider">
                <?php while ($courses_query->have_posts()):
                    $courses_query->the_post();
                ?>

                    <div>
                        <div class="course-box">
                            <div class="img-box">
                                <?php if (has_post_thumbnail()) {
                                    the_post_thumbnail('full', array('class' => 'img-fluid'));
                                } ?>
                            </div>
                            <div class="course-content">
                                <h3><?php echo get_the_title(); ?></h3>
                                <p><?php echo the_excerpt(); ?>
                                </p>
                                <a href="<?php the_permalink(); ?>" class="outline-btn">Learn More <img
                                        src="https://draftsite1.com/websentials-academy/wp-content/uploads/2025/03/arrow-topright.svg"
                                        alt=""></a>
                            </div>
                        </div>
                    </div>
                <?php endwhile; ?>
            </div>

        <?php else:
        echo 'No courses found.';
    endif;

    wp_reset_postdata();

    return ob_get_clean();
}
add_shortcode('courses_slider', 'display_courses_slider');

// courses slider  end -----------------------------------------------------

// courses page start ------------------------------------------------------------

function display_courses($atts)
{
    // Attributes
    $atts = shortcode_atts(
        array(
            'posts_per_page' => 9,
            'category' => isset($_GET['category']) ? sanitize_text_field($_GET['category']) : '',
        ),
        $atts,
        'courses'
    );

    // Get the current page


    $args = array(
        'post_type' => 'courses',
        'posts_per_page' => $atts['posts_per_page'],
        'paged' => get_query_var('paged') ? get_query_var('paged') : 1,
    );


    $courses_query = new WP_Query($args);

    ob_start();

    if ($courses_query->have_posts()): ?>
            <div class="courses-page courses-main">
                <div class="row g-lg-4 g-3">
                    <?php while ($courses_query->have_posts()):
                        $courses_query->the_post();

                    ?>

                        <div class="col-lg-4 col-md-4 col-sm-6">
                            <div class="course-box">
                                <div class="img-box">
                                    <?php if (has_post_thumbnail()) {
                                        the_post_thumbnail('full', array('class' => 'img-fluid'));
                                    } ?>
                                </div>
                                <div class="course-content">
                                    <h3><?php echo get_the_title(); ?></h3>
                                    <p><?php echo the_excerpt(); ?>
                                    </p>
                                    <a href="<?php the_permalink(); ?>" class="outline-btn">Learn More <img
                                            src="https://draftsite1.com/websentials-academy/wp-content/uploads/2025/03/arrow-topright.svg"
                                            alt=""></a>
                                </div>
                            </div>
                        </div>


                    <?php endwhile; ?>
                </div>
            </div>


            <div class="pagination-center text-center mt-md-5 mt-3 mb-3">
                <div class="pagination-two d-inline-block">
                    <?php
                    echo paginate_links(
                        array(
                            'total' => $courses_query->max_num_pages,
                            'current' => max(1, get_query_var('paged')),
                            'format' => '?paged=%#%',
                            'show_all' => false,
                            'type' => 'plain',
                            'prev_text' => __('<img src="https://draftsite1.com/websentials-academy/wp-content/uploads/2025/03/arrow-left-circle-1.svg">'),
                            'next_text' => __('<img src="https://draftsite1.com/websentials-academy/wp-content/uploads/2025/03/arrow-right-circle.svg">'),
                            'end_size' => 2,
                            'mid_size' => 2
                        )
                    );
                    ?>
                </div>
            </div>

        <?php else:
        echo 'No courses found.';
    endif;

    wp_reset_postdata();

    return ob_get_clean();
}
add_shortcode('courses', 'display_courses');


// courses page End ------------------------------------------------------------






// Blogs page start ------------------------------------------------------------

function display_featured_blogs($atts)
{
    // Attributes
    $atts = shortcode_atts(
        array(
            'posts_per_page' => 6,
            'category' => isset($_GET['category']) ? sanitize_text_field($_GET['category']) : '',
        ),
        $atts,
        'all_blogs'
    );

    // Fetch the latest featured post
    $featured_args = array(
        'post_type' => 'post',
        'posts_per_page' => 1,
        'meta_query' => array(
            array(
                'key' => '_thumbnail_id',
                'compare' => 'EXISTS',
            ),
        ),
        'orderby' => 'date',
        'order' => 'DESC',
    );

    $featured_query = new WP_Query($featured_args);
    $featured_post_id = $featured_query->have_posts() ? $featured_query->posts[0]->ID : 0;

    // Fetch remaining posts (excluding the featured post)
    $args = array(
        'post_type' => 'post',
        'posts_per_page' => $atts['posts_per_page'],
        'paged' => get_query_var('paged') ? get_query_var('paged') : 1,
        'post__not_in' => $featured_post_id ? array($featured_post_id) : array(),
    );

    $articles_query = new WP_Query($args);

    ob_start();
        ?>

        <div class="row g-lg-5 g-3">

            <?php
            if ($featured_query->have_posts()):
                while ($featured_query->have_posts()):
                    $featured_query->the_post();
            ?>
                    <div class="col-lg-12">
                        <div class="blog-box featured" data-post-id="<?php echo get_the_ID(); ?>">
                            <a href="<?php the_permalink(); ?>">
                                <div class="row g-md-5 align-items-center">
                                    <div class="col-lg-6 col-md-6 col-sm-7 mb-4 mb-sm-0">
                                        <span class=" blog-batch">
                                            Featured
                                        </span>

                                        <h3><?php echo get_the_title(); ?></h3>
                                        <img src="https://draftsite1.com/websentials-academy/wp-content/uploads/2025/03/arrow-topright.png"
                                            alt="" class="arrow-icon-f pt-2" style="width:20px;">
                                    </div>

                                    <div class="col-lg-6 col-md-6 col-sm-5">
                                        <?php if (has_post_thumbnail()) {
                                            the_post_thumbnail('full', array('class' => 'w-100 rounded-4'));
                                        } ?>
                                    </div>

                                </div>
                            </a>
                        </div>
                    </div>
            <?php endwhile;
                wp_reset_postdata();
            endif;
            ?>

            <div class="pt-2 pb-2">
                <div class="divider-blog"></div>
            </div>

            <?php
            if ($articles_query->have_posts()):
                while ($articles_query->have_posts()):
                    $articles_query->the_post();
                    $post_tags = get_the_tags();
            ?>
                    <div class="col-lg-6 col-md-6">
                        <div class="blog-box" data-post-id="<?php echo get_the_ID(); ?>">
                            <a href="<?php the_permalink(); ?>">
                                <div class="row">
                                    <div class="col-lg-6 col-md-6 col-sm-5 mb-4 mb-sm-0">
                                        <?php if (has_post_thumbnail()) {
                                            the_post_thumbnail('full', array('class' => 'w-100 rounded-4 main-img'));
                                        } ?>
                                    </div>
                                    <div class="col-lg-6 col-md-6 col-sm-7 position-relative">
                                        <?php if ($post_tags): ?>
                                            <div class="tags">
                                                <?php foreach ($post_tags as $tag): ?>
                                                    <span class="blog-batch">

                                                        <?php echo esc_html($tag->name); ?>

                                                        <!-- <a href="<?php // echo get_tag_link($tag->term_id); 
                                                                        ?>">
                                                            <?php // echo esc_html($tag->name); 
                                                            ?>
                                                        </a> -->
                                                    </span>
                                                <?php endforeach; ?>
                                            </div>
                                        <?php endif; ?>
                                        <h4><?php echo get_the_title(); ?></h4>
                                        <img src="https://draftsite1.com/websentials-academy/wp-content/uploads/2025/03/arrow-topright.svg"
                                            alt="" class="arrow-icon">
                                    </div>
                                </div>
                            </a>
                        </div>
                    </div>
                <?php endwhile; ?>

                <div class="pagination-center text-center mt-md-5 mt-3 mb-3">
                    <div class="pagination-two d-inline-block">
                        <?php
                        echo paginate_links(
                            array(
                                'total' => $articles_query->max_num_pages,
                                'current' => max(1, get_query_var('paged')),
                                'format' => '?paged=%#%',
                                'show_all' => false,
                                'type' => 'plain',
                                'prev_text' => __('<img src="https://draftsite1.com/websentials-academy/wp-content/uploads/2025/03/arrow-left-circle-1.svg">'),
                                'next_text' => __('<img src="https://draftsite1.com/websentials-academy/wp-content/uploads/2025/03/arrow-right-circle.svg">'),
                                'end_size' => 2,
                                'mid_size' => 2
                            )
                        );
                        ?>
                    </div>
                </div>

            <?php else:
                echo 'No Blog found.';
            endif;

            wp_reset_postdata();
            ?>

        </div>

        <?php
        return ob_get_clean();
    }

    add_shortcode('featured_blogs', 'display_featured_blogs');


    function get_related_articles($post_id, $number_of_posts = 3)
    {
        $current_post = get_post($post_id);
        $related_posts = array();

        // Get categories of the current post
        $categories = wp_get_post_categories($post_id);
        if ($categories) {
            $args = array(
                'category__in' => $categories,
                'post__not_in' => array($post_id),
                'posts_per_page' => $number_of_posts,
                'ignore_sticky_posts' => 1,
            );
            $related_posts = get_posts($args);
        }

        // If not enough related posts by category, get related posts by tag
        if (count($related_posts) < $number_of_posts) {
            $tags = wp_get_post_tags($post_id);
            if ($tags) {
                $tag_ids = array();
                foreach ($tags as $tag) {
                    $tag_ids[] = $tag->term_id;
                }
                $args = array(
                    'tag__in' => $tag_ids,
                    'post__not_in' => array_merge(array($post_id), wp_list_pluck($related_posts, 'ID')),
                    'posts_per_page' => $number_of_posts - count($related_posts),
                    'ignore_sticky_posts' => 1,
                );
                $more_related_posts = get_posts($args);
                $related_posts = array_merge($related_posts, $more_related_posts);
            }
        }

        return $related_posts;
    }
    // Blogs page End ------------------------------------------------------------


    // events page start ------------------------------------------------------------


    function register_custom_tags()
    {
        register_taxonomy(
            'events_tag',  // Change this to your custom taxonomy slug
            'events', // Change this to your custom post type slug
            array(
                'label' => __('events Tags'),
                'rewrite' => array('slug' => 'events-tag'),
                'hierarchical' => false, // false = like post tags, true = like categories
                'show_admin_column' => true,
                'show_ui' => true,
                'query_var' => true,
            )
        );
    }
    add_action('init', 'register_custom_tags');



    function display_events($atts)
    {
        // Attributes
        $atts = shortcode_atts(
            array(
                'posts_per_page' => 9,
                'category' => isset($_GET['category']) ? sanitize_text_field($_GET['category']) : '',
            ),
            $atts,
            'events'
        );

        // Fetch the latest featured post
        $featured_args = array(
            'post_type' => 'events',
            'posts_per_page' => 1,
            'meta_query' => array(
                array(
                    'key' => '_thumbnail_id',
                    'compare' => 'EXISTS',
                ),
            ),
            'orderby' => 'date',
            'order' => 'DESC',
        );

        $featured_query = new WP_Query($featured_args);
        $featured_post_id = $featured_query->have_posts() ? $featured_query->posts[0]->ID : 0;


        $args = array(
            'post_type' => 'events',
            'posts_per_page' => $atts['posts_per_page'],
            'paged' => get_query_var('paged') ? get_query_var('paged') : 1,
            'post__not_in' => $featured_post_id ? array($featured_post_id) : array(),
        );





        // Filter by category if provided
        if (!empty($atts['category'])) {
            $args['tax_query'] = array(
                array(
                    'taxonomy' => 'events-category',
                    'field' => 'slug',
                    'terms' => $atts['category'],
                ),
            );
        }
        // Get categories
        $categories = get_terms(array(
            'taxonomy' => 'events-category',
            'hide_empty' => true,
        ));

        if ($categories):
        ?>
            <div class="col-lg-12 mb-5">
                <ul id="category-filter-list" class="document-filter nav justify-content-center">

                    <li><a href="<?php echo esc_url(add_query_arg('category', '', home_url('/events'))); ?>"
                            class="all-cat-head <?php echo empty($atts['category']) ? 'active' : ''; ?>"> All </a></li>
                    <?php foreach ($categories as $category):
                        $active_class = ($atts['category'] === $category->slug) ? 'active' : '';
                    ?>
                        <li>
                            <a href="<?php echo esc_url(add_query_arg('category', $category->slug, home_url('/events'))); ?>"
                                class="cats <?php echo esc_attr($active_class); ?>">
                                <?php echo esc_html($category->name); ?>
                            </a>
                        </li>
                    <?php endforeach; ?>
                </ul>
            </div>
        <?php
        endif;




        $events_query = new WP_Query($args);

        ob_start();

        if ($events_query->have_posts()): ?>
            <div class="testimonial-page events-main">
                <div class="row gy-3 mx-0">

                    <?php
                    if ($featured_query->have_posts()):
                        while ($featured_query->have_posts()):
                            $featured_query->the_post();
                    ?>
                            <div class="col-lg-12">
                                <div class="event-box bg-transparent featured" data-post-id="<?php echo get_the_ID(); ?>">
                                    <a href="<?php the_permalink(); ?>">
                                        <div class="row g-md-5 align-items-center ">
                                            <div class="col-lg-6 col-md-6 col-sm-7 mb-4 mb-sm-0">
                                                <span class="blog-batch">
                                                    Featured
                                                </span>

                                                <h3><?php echo get_the_title(); ?></h3>


                                                <p> <?php echo the_excerpt(); ?> </p>
                                                <br>
                                                <a href="<?php the_permalink(); ?>" class="elementor-button">View More <img
                                                        src="https://draftsite1.com/websentials-academy/wp-content/uploads/2025/03/arrow-topright.svg"
                                                        alt=""></a>
                                            </div>

                                            <div class="col-lg-6 col-md-6 col-sm-5">
                                                <?php if (has_post_thumbnail()) {
                                                    the_post_thumbnail('full', array('class' => 'w-100 rounded-4'));
                                                } ?>
                                            </div>

                                        </div>
                                    </a>
                                </div>
                            </div>
                    <?php endwhile;
                        wp_reset_postdata();
                    endif;
                    ?>

                    <div class="pt-5 pb-5">

                    </div>

                    <?php while ($events_query->have_posts()):
                        $events_query->the_post();

                    ?>

                        <div class="col-lg-4 col-md-4 col-sm-6">
                            <div class="event-box">
                                <?php
                                $featured_video = get_field('featured_video'); // Get the featured video field.
                                ?>
                                <?php
                                if ($featured_video) {
                                    $file_url = is_array($featured_video) ? $featured_video['url'] : $featured_video;
                                    echo '<div class="videos-box mb-3">
                                        <video controls width="100%">
                                            <source src="' . esc_url($file_url) . '" type="video/mp4" class="video-box">
                                        </video>
                                    </div>';
                                } elseif (has_post_thumbnail()) {
                                    echo '<div class="img-box mb-3">';
                                    the_post_thumbnail('full', array('class' => 'w-100 main-img mb-3'));
                                    echo '</div>';
                                }
                                ?>



                                <div class="text-box">
                                    <?php $tags = get_the_terms(get_the_ID(), 'events_tag');
                                    if ($tags && !is_wp_error($tags)) {
                                        foreach ($tags as $tag) {
                                            echo '<span class="blog-batch">' . esc_html($tag->name) . '</span> ';
                                        }
                                    } ?>



                                    <h4><?php echo get_the_title(); ?></h4>
                                    <p> <?php echo the_excerpt(); ?>
                                    </p>
                                    <a href="<?php the_permalink(); ?>" class="elementor-button">View More <img
                                            src="https://draftsite1.com/websentials-academy/wp-content/uploads/2025/03/arrow-topright.svg"
                                            alt=""></a>
                                </div>
                            </div>
                        </div>

                    <?php endwhile; ?>
                </div>

                <!-- Gallery Modal -->
                <div class="modal fade" id="galleryModal">
                    <small class="btn-close btn-close-white border-0" type="button" data-bs-dismiss="modal"></small>
                    <div class="modal-dialog modal-dialog-centered modal-lg">
                        <div class="modal-content bg-transparent border-0 rounded-0">
                            <!-- Modal body -->
                            <div class="modal-body">

                                <!-- Carousel -->
                                <div id="demo" class="carousel slide" data-bs-ride="carousel">

                                    <!-- The slideshow/carousel -->
                                    <div class="carousel-inner">
                                        <div class="carousel-item active">
                                            <img src="https://draftsite1.com/websentials-academy/wp-content/uploads/2025/03/Mask-Group-40-1.png"
                                                class="d-block w-100">
                                        </div>
                                        <div class="carousel-item">
                                            <img src="https://draftsite1.com/websentials-academy/wp-content/uploads/2025/03/Mask-Group-40-1.png"
                                                class="d-block w-100">
                                        </div>
                                        <div class="carousel-item">
                                            <img src="https://draftsite1.com/websentials-academy/wp-content/uploads/2025/03/Mask-Group-40-1.png"
                                                class="d-block w-100">
                                        </div>
                                    </div>
                                    <!-- Indicators/dots -->
                                    <div class="carousel-indicators ">
                                        <button type="button" data-bs-target="#demo" data-bs-slide-to="0" class="active">
                                            <img src="https://draftsite1.com/websentials-academy/wp-content/uploads/2025/03/Mask-Group-40-1.png"
                                                class="d-block w-100">
                                        </button>
                                        <button type="button" data-bs-target="#demo" data-bs-slide-to="1">
                                            <img src="https://draftsite1.com/websentials-academy/wp-content/uploads/2025/03/Mask-Group-40-1.png"
                                                class="d-block w-100">
                                        </button>
                                        <button type="button" data-bs-target="#demo" data-bs-slide-to="2">
                                            <img src="https://draftsite1.com/websentials-academy/wp-content/uploads/2025/03/Mask-Group-40-1.png"
                                                class="d-block w-100">
                                        </button>
                                    </div>

                                    <!-- Left and right controls/icons -->
                                    <small class="carousel-control-prev" data-bs-target="#demo" data-bs-slide="prev">
                                        <span class="carousel-control-prev-icon"></span>
                                    </small>
                                    <small class="carousel-control-next" data-bs-target="#demo" data-bs-slide="next">
                                        <span class="carousel-control-next-icon"></span>
                                    </small>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Video Modal -->
                <div class="modal fade" id="videoModal">
                    <small class="btn-close btn-close-white border-0" type="button" data-bs-dismiss="modal"></small>
                    <div class="modal-dialog modal-dialog-centered modal-lg">

                        <div class="modal-content bg-transparent border-0 rounded-0">
                            <!-- Modal body -->

                            <div class="modal-body">
                                <video width="100%" height="340" class="mb-3">
                                    <source src="movie.mp4" type="video/mp4">
                                </video>
                                <p class="text-center fw-bold text-white">Building Smart Chatbots with AI</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>


            <script type="text/javascript">
                document.addEventListener('DOMContentLoaded', function() {
                    var listItems = document.querySelectorAll('#category-filter-list a');
                    listItems.forEach(function(item) {
                        item.addEventListener('click', function(event) {
                            // No need to prevent default here; the link's href handles the filtering
                        });
                    });
                });
            </script>

            <div class="pagination-center text-center mt-md-5 mt-3 mb-3">
                <div class="pagination-two d-inline-block">
                    <?php
                    echo paginate_links(
                        array(
                            'total' => $events_query->max_num_pages,
                            'current' => max(1, get_query_var('paged')),
                            'format' => '?paged=%#%',
                            'show_all' => false,
                            'type' => 'plain',
                            'prev_text' => __('<img src="https://draftsite1.com/websentials-academy/wp-content/uploads/2025/03/arrow-left-circle-1.svg">'),
                            'next_text' => __('<img src="https://draftsite1.com/websentials-academy/wp-content/uploads/2025/03/arrow-right-circle.svg">'),
                            'end_size' => 2,
                            'mid_size' => 2
                        )
                    );
                    ?>
                </div>
            </div>

    <?php else:
            echo 'No events found.';
        endif;

        wp_reset_postdata();

        return ob_get_clean();
    }
    add_shortcode('events', 'display_events');


    // events page end ------------------------------------------------------------






    function all_events()
    {
        // Define your HTML content here
        $html_content = '
		<div class="row g-3">
            <div class="col-lg-4 col-md-4">
                <div class="event-box">
                    <img src="https://draftsite1.com/websentials-academy/wp-content/uploads/2025/03/Mask-Group-40-1.png" alt="" class="w-100 main-img mb-3">
                    <div class="text-box">
                        <span class="blog-batch">Events</span>
                        <h4>The Power of Content: Creating Engaging Posts That Convert</h4>                                
                        <p>A casual meet-up to share insights and foster collaboration between businesses and learners.</p>
                        <a href="#" class="elementor-button" data-bs-toggle="modal" data-bs-target="#galleryModal">View Gallery <img src="https://draftsite1.com/websentials-academy/wp-content/uploads/2025/03/arrow-topright.svg" alt=""></a>
                    </div>
                </div>
            </div>
            <div class="col-lg-4 col-md-4">
                <div class="event-box">
                    <img src="https://draftsite1.com/websentials-academy/wp-content/uploads/2025/03/Mask-Group-40-1.png" alt="" class="w-100 main-img mb-3">
                    <div class="text-box">
                        <span class="blog-batch">Events</span>
                        <h4>The Power of Content: Creating Engaging Posts That Convert</h4>                                
                        <p>A casual meet-up to share insights and foster collaboration between businesses and learners.</p>
                        <a href="#" class="elementor-button" data-bs-toggle="modal" data-bs-target="#videoModal">Watch Video <img src="https://draftsite1.com/websentials-academy/wp-content/uploads/2025/03/arrow-topright.svg" alt=""></a>
                    </div>
                </div>
            </div>
            <div class="col-lg-4 col-md-4">
                <div class="event-box">
                    <img src="https://draftsite1.com/websentials-academy/wp-content/uploads/2025/03/Mask-Group-40-1.png" alt="" class="w-100 main-img mb-3">
                    <div class="text-box">
                        <span class="blog-batch">Events</span>
                        <h4>The Power of Content: Creating Engaging Posts That Convert</h4>                                
                        <p>A casual meet-up to share insights and foster collaboration between businesses and learners.</p>
                        <a href="#" class="elementor-button">View More <img src="https://draftsite1.com/websentials-academy/wp-content/uploads/2025/03/arrow-topright.svg" alt=""></a>
                    </div>
                </div>
            </div>
        </div>

        <!-- Gallery Modal -->
        <div class="modal fade" id="galleryModal">
        <small class="btn-close btn-close-white border-0" type="button" data-bs-dismiss="modal"></small>
            <div class="modal-dialog modal-dialog-centered modal-lg">            
                <div class="modal-content bg-transparent border-0 rounded-0">
                    <!-- Modal body -->
                    <div class="modal-body">
                        
                        <!-- Carousel -->
                        <div id="demo" class="carousel slide" data-bs-ride="carousel">                        

                        <!-- The slideshow/carousel -->
                        <div class="carousel-inner">
                            <div class="carousel-item active">
                                <img src="https://draftsite1.com/websentials-academy/wp-content/uploads/2025/03/Mask-Group-40-1.png" class="d-block w-100">
                            </div>
                            <div class="carousel-item">
                                <img src="https://draftsite1.com/websentials-academy/wp-content/uploads/2025/03/Mask-Group-40-1.png" class="d-block w-100">
                            </div>
                            <div class="carousel-item">
                                <img src="https://draftsite1.com/websentials-academy/wp-content/uploads/2025/03/Mask-Group-40-1.png" class="d-block w-100">
                            </div>
                        </div>
                        <!-- Indicators/dots -->
                        <div class="carousel-indicators ">
                            <button type="button" data-bs-target="#demo" data-bs-slide-to="0" class="active">
                                <img src="https://draftsite1.com/websentials-academy/wp-content/uploads/2025/03/Mask-Group-40-1.png" class="d-block w-100">
                            </button>
                            <button type="button" data-bs-target="#demo" data-bs-slide-to="1">
                                <img src="https://draftsite1.com/websentials-academy/wp-content/uploads/2025/03/Mask-Group-40-1.png" class="d-block w-100">
                            </button>
                            <button type="button" data-bs-target="#demo" data-bs-slide-to="2">
                                <img src="https://draftsite1.com/websentials-academy/wp-content/uploads/2025/03/Mask-Group-40-1.png" class="d-block w-100">
                            </button>
                        </div>

                        <!-- Left and right controls/icons -->
                        <small class="carousel-control-prev"  data-bs-target="#demo" data-bs-slide="prev">
                            <span class="carousel-control-prev-icon"></span>
                        </small>
                        <small class="carousel-control-next"  data-bs-target="#demo" data-bs-slide="next">
                            <span class="carousel-control-next-icon"></span>
                        </small>
                        </div>
                    </div>                        
                </div>
            </div>
        </div>

        <!-- Video Modal -->
        <div class="modal fade" id="videoModal">
        <small class="btn-close btn-close-white border-0" type="button" data-bs-dismiss="modal"></small>              
            <div class="modal-dialog modal-dialog-centered modal-lg">
            
                <div class="modal-content bg-transparent border-0 rounded-0">
                    <!-- Modal body -->      
                    
                    <div class="modal-body">                        
                        <video width="100%" height="340" class="mb-3">
                            <source src="movie.mp4" type="video/mp4">
                        </video>
                        <p class="text-center fw-bold text-white">Building Smart Chatbots with AI</p>
                    </div>                        
                </div>
            </div>
        </div>
	';
        return $html_content;
    }
    add_shortcode('all_events', 'all_events');
