<?php get_header(); ?>
<div class="page-single">
    <div class="breadcrumb-single">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <nav aria-label="breadcrumb" class="pt-4">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="#">Home</a></li>
                            <li class="breadcrumb-item"><a href="#">Events</a></li>
                            <li class="breadcrumb-item active" aria-current="page"><?php the_title(); ?></li>
                        </ol>
                    </nav>
                </div>
            </div>
        </div>
    </div>


    <div class="single-promotion-detail">
        <div class="container">

            <?php
            if (have_posts()):
                while (have_posts()):
                    the_post();
            ?>


                    <div class="row justify-content-center py-5">
                        <div class="col-lg-10">


                            <?php
                            $featured_video = get_field('featured_video');
                            ?>
                            <div class="content-box mb-3">
                                <?php
                                if ($featured_video) {

                                    $file_url = is_array($featured_video) ? $featured_video['url'] : $featured_video;
                                    echo '<div class="videos-box mb-5">
                                        <video controls width="100%">
                                            <source src="' . esc_url($file_url) . '" type="video/mp4" class="video-box">
                                        </video>
                                    </div>';
                                } elseif (has_post_thumbnail()) {

                                    echo '<div class="img-box mb-3">';
                                    the_post_thumbnail('full', array('class' => 'w-100 mb-5'));
                                    echo '</div>';
                                }
                                ?>
                            </div>


                            <?php $tags = get_the_terms(get_the_ID(), 'events_tag');
                            if ($tags && !is_wp_error($tags)) {
                                foreach ($tags as $tag) {
                                    echo '<span class="blog-batch">' . esc_html($tag->name) . '</span> ';
                                }
                            } ?>

                            <h1 class="blog-title mt-4 mb-4"><?php the_title(); ?></h1>

                            <div class="description mb-5">
                                <?php the_content(); ?>
                            </div>
                            <div class="gallery mb-5">

                                <?php
                                $images = get_field('gallery_image', $post->ID);

                                if ($images && count($images)):

                                    $per_page = 12; // Number of images per page
                                    $current_page = max(1, get_query_var('paged')); // Get current page number
                                    $total_images = count($images);
                                    $total_pages = ceil($total_images / $per_page);

                                    // Calculate the images for the current page
                                    $offset = ($current_page - 1) * $per_page;
                                    $current_images = array_slice($images, $offset, $per_page);
                                ?>

                                    <div class="gallery-section pt-5">
                                        <div class="event-gallery">
                                            <div class="container">
                                                <div class="row g-md-4 g-3" id="gallery-container">
                                                    <?php foreach ($current_images as $image): ?>
                                                        <div class="col-md-6 col-sm-6">
                                                            <div class="thumbnail">
                                                                <a href="<?php echo esc_url($image['url']); ?>" target="_blank">
                                                                    <img src="<?php echo esc_url($image['sizes']['large']); ?>" alt="<?php echo esc_attr($image['alt']); ?>" class="w-100">
                                                                </a>
                                                            </div>
                                                        </div>
                                                    <?php endforeach; ?>
                                                </div>
                                            </div>

                                            <!-- Pagination -->
                                            <div class="pagination-center text-center mt-md-5 mt-3 mb-3">
                                                <div class="pagination-two">
                                                    <?php
                                                    echo paginate_links(
                                                        array(
                                                            'total' => $total_pages,
                                                            'current' => $current_page,
                                                            'format' => '?paged=%#%',
                                                            'show_all' => false,
                                                            'type' => 'plain',
                                                            'prev_text' => __('<img src="https://draftsite1.com/websentials-academy/wp-content/uploads/2025/03/arrow-left-circle-1.svg">'),
                                                            'next_text' => __('<img src="https://draftsite1.com/websentials-academy/wp-content/uploads/2025/03/arrow-right-circle.svg">'),
                                                            'end_size' => 2,
                                                            'mid_size' => 2
                                                        )
                                                    );
                                                    ?>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                <?php
                                endif;
                                ?>
                            </div>

                        </div>
                    </div>




            <?php endwhile;
            else:
                echo '<p>' . __('No Post found', 'textdomain') . '</p>';
            endif;
            ?>


        </div>
    </div>

</div>




<?php get_footer(); ?>