<?php get_header(); ?>
<div class="page-single">
    <div class="breadcrumb-single">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <nav aria-label="breadcrumb" class="pt-4">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="#">Home</a></li>
                            <li class="breadcrumb-item"><a href="#">Blog</a></li>
                            <li class="breadcrumb-item active" aria-current="page"><?php the_title(); ?></li>
                        </ol>
                    </nav>
                </div>
            </div>
        </div>
    </div>


    <div class="single-promotion-detail">
        <div class="container">

            <?php
            if (have_posts()):
                while (have_posts()):
                    the_post();
            ?>

                    <div class="row justify-content-center py-5">

                        <div class="col-lg-12">
                            <h1 class="blog-title mb-4"><?php the_title(); ?></h1>
                            <p class="mb-4 pb-4"><i> Posted on <?php echo get_the_date(); ?></i></p>
                        </div>
                        <div class="col-lg-10">

                            <?php if (has_post_thumbnail()) {
                                the_post_thumbnail('full', array('class' => 'w-100 mb-5'));
                            } ?>


                            <!-- <video width="100%" height="340" controls class="mb-5">
                                <source src="movie.mp4" type="video/mp4">
                            </video> -->
                            <div class="mb-5"><?php the_content(); ?> </div>
                        </div>
                    </div>

            <?php endwhile;
            else:
                echo '<p>' . __('No Post found', 'textdomain') . '</p>';
            endif;
            ?>

            <div class="row py-5">
                <div class="col-lg-12">
                    <h2 class="heading2 pb-2 pb-lg-4">Related Articles </h2>

                    <?php
                    $related_posts = get_related_articles(get_the_ID(), 3);

                    if (!empty($related_posts)): ?>

                        <div class="slick-slider blog-slider">
                            <?php foreach ($related_posts as $post):
                                setup_postdata($post); ?>

                                <div class="py-3">
                                    <div class="blog-box">
                                        <a href="<?php the_permalink(); ?>">
                                            <div class="row m-0">
                                                <div class="col-lg-6 col-md-6 col-sm-5 mb-4 mb-sm-0">
                                                    <?php if (has_post_thumbnail()) {
                                                        the_post_thumbnail('full', array('class' => 'w-100 rounded-4 main-img'));
                                                    } ?>
                                                </div>
                                                <div class="col-lg-6 col-md-6 col-sm-7 position-relative">
                                                    <span class="blog-batch">Content Creation</span>
                                                    <h4><?php echo get_the_title(); ?></h4>
                                                    <img src="https://draftsite1.com/websentials-academy/wp-content/uploads/2025/03/arrow-topright.svg"
                                                        alt="" class="arrow-icon">
                                                </div>
                                            </div>
                                        </a>
                                    </div>
                                </div>

                            <?php endforeach; ?>


                        <?php
                        wp_reset_postdata();
                    endif;
                        ?>


                        </div>


                </div>
            </div>



        </div>
    </div>



</div>




<?php get_footer(); ?>