<?php

function hello_elementor_child_enqueue_styles()
{
    wp_enqueue_style('hello-elementor-parent-style', get_template_directory_uri() . '/../hello-elementor-child/style.css');
    wp_enqueue_style('hello-elementor-parent-ecommerce', get_template_directory_uri() . '/../hello-elementor-child/ecommerce.css');
}
add_action('wp_enqueue_scripts', 'hello_elementor_child_enqueue_styles');


// Enqueue Booststrap 
function enqueue_bootstrap()
{
    wp_enqueue_style('bootstrap-css', 'https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css');
    wp_enqueue_script('bootstrap-js', 'https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.min.js', array('jquery'), null, true);

}
add_action('wp_enqueue_scripts', 'enqueue_bootstrap');


//  Slick carousel script and styles
function enqueue_slick_scripts()
{
    wp_enqueue_script('slick-js', 'https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.9.0/slick.min.js', array('jquery'), null, true);
    wp_enqueue_style('slick-css', 'https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.9.0/slick.min.css');
}
add_action('wp_enqueue_scripts', 'enqueue_slick_scripts');


function enqueue_custom_script()
{
    wp_enqueue_script(
        'custom-script',
        get_template_directory_uri() . '../../hello-elementor-child/custom-script.js',
        array('jquery'),
        null,
        true
    );
}
add_action('wp_enqueue_scripts', 'enqueue_custom_script');



// custom code



// testimonials slider start------------------
function display_testimonials_slider($atts)
{
    // Attributes
    $atts = shortcode_atts(
        array(
            'posts_per_page' => -1,
        ),
        $atts,
        'testimonials'
    );

    $args = array(
        'post_type' => 'testimonial',
        'posts_per_page' => $atts['posts_per_page'],
        'meta_query' => array(
            array(
                'key' => '_is_ns_featured_post',
                'value' => 'yes',
                'compare' => '='
            )
        )
    );

    $testimonials_query = new WP_Query($args);


    ob_start();

    if ($testimonials_query->have_posts()): ?>
          <div class="testimonials-slider">
             <div class="testimonials-slider-two">
                <?php while ($testimonials_query->have_posts()):
                    $testimonials_query->the_post();
                    ?>

                     <div class="item ps-2 pe-2 pt-3">
                            <div class="testimonials-box-main" id="<?php echo get_the_ID(); ?>">
                            <div class="testimonials-box-two">
                                <div class="content-box">

                                <?php
                                $rating = get_field('rating');
                                if ($rating):
                                    echo '<div class="rating">';
                                    echo str_repeat('★', $rating);
                                    echo '</div>';
                                endif; ?>
                                    <div class="description mt-2">
                                    <?php echo get_the_content(); ?>

                                    <?php /*
                                $content = get_the_content();
                                $word_count = str_word_count(wp_strip_all_tags(strip_shortcodes($content)));
                                if ($word_count > 25):
                                    ?>
                                    <a data-bs-toggle="modal" data-bs-target="#exampleModal<?php echo get_the_ID(); ?>"
                                        class="read-more-testimonial"> Read More</a>
                                <?php endif; */ ?>
                                    </div>
                                </div>

                                <div class="testimonials-wrap">
                                    <div class="img-wrap">
                                    <?php if (has_post_thumbnail()) {
                                        the_post_thumbnail('full', array('class' => 'd-block w-100'));
                                    } ?>
                                    </div>
                                    <div>
                                        <h1 class="title"> <?php echo get_the_title(); ?> </h1>
                                    </div>
                                </div>
                            </div>
                            </div>
                        </div>

         
                <?php endwhile; ?>
            </div>
        </div>

        <?php while ($testimonials_query->have_posts()):
            $testimonials_query->the_post(); ?>
            <div class="model-testimonial modal modal-md" id="exampleModal<?php echo get_the_ID(); ?>" tabindex="-1"
                aria-labelledby="exampleModalLabel" aria-hidden="true">
                <div class="modal-dialog modal-lg modal-dialog-centered">
                    <div class="modal-content">
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        <div class="modal-body p-0">


                            <div class="testimonial-model">
                                <div class="testimonials-box-popup" id="<?php echo get_the_ID(); ?>">
                                    <div class="row">
                                        <div class="col-md-3">
                                            <div class="img-wrap">
                                                <?php if (has_post_thumbnail()) {
                                                    the_post_thumbnail('full', array('class' => 'd-block w-100'));
                                                } ?>
                                            </div>
                                        </div>
                                        <div class="col-md-9">
                                            <div class="testimonials-wrap">
                                                <h1 class="title mt-0"> <?php echo get_the_title(); ?> </h1>
                                                <?php
                                                $position = get_field('position');
                                                if ($position):
                                                    echo '<p class="position mb-0">';
                                                    echo $position;
                                                    echo '</p>';
                                                endif; ?>
                                            </div>

                                            <div class="rating-area">
                                                <?php
                                                $rating = get_field('rating');
                                                if ($rating):
                                                    echo '<div class="rating">';
                                                    echo str_repeat('★', $rating);
                                                    echo '</div>';
                                                endif;
                                                ?>
                                            </div>

                                            <div class="content-box">
                                                <div class="description">
                                                    <?php echo get_the_content(); ?>
                                                </div>
                                            </div>

                                        </div>
                                    </div>

                                </div>
                            </div>


                        </div>
                    </div>
                </div>
            </div>

        <?php endwhile; ?>

    <?php else:
        echo 'No testimonials found.';
    endif;

    wp_reset_postdata();

    return ob_get_clean();
}
add_shortcode('testimonials_slider', 'display_testimonials_slider');
// testimonials slider end ------------------------------





function display_testimonials($atts)
{
    // Attributes
    $atts = shortcode_atts(
        array(
            'posts_per_page' => 9,
        ),
        $atts,
        'testimonials'
    );

    // Get the current page


    $args = array(
        'post_type' => 'testimonial',
        'posts_per_page' => $atts['posts_per_page'],
        'paged' => get_query_var('paged') ? get_query_var('paged') : 1,
        'orderby' => 'date',
        'order' => 'DESC',
    );


    $testimonials_query = new WP_Query($args);

    ob_start();

    if ($testimonials_query->have_posts()): ?>
        <div class="testimonials-page testimonials-main">
            <div class="row g-md-4 g-3 pt-3">
                <?php while ($testimonials_query->have_posts()):
                    $testimonials_query->the_post();
                    ?>
                    <div class="col-md-4">

                    <div class="testimonials-box-main" id="<?php echo get_the_ID(); ?>">
                            <div class="testimonials-box-two">
                                <div class="content-box">

                                <?php
                                $rating = get_field('rating');
                                if ($rating):
                                    echo '<div class="rating">';
                                    echo str_repeat('★', $rating);
                                    echo '</div>';
                                endif; ?>
                                    <div class="description mt-2">
                                    <?php echo get_the_content(); ?>

                                    <?php /*
                                $content = get_the_content();
                                $word_count = str_word_count(wp_strip_all_tags(strip_shortcodes($content)));
                                if ($word_count > 25):
                                    ?>
                                    <a data-bs-toggle="modal" data-bs-target="#exampleModal<?php echo get_the_ID(); ?>"
                                        class="read-more-testimonial"> Read More</a>
                                <?php endif; */ ?>
                                    </div>
                                </div>

                                <div class="testimonials-wrap">
                                    <div class="img-wrap">
                                    <?php if (has_post_thumbnail()) {
                                        the_post_thumbnail('full', array('class' => 'd-block w-100'));
                                    } ?>
                                    </div>
                                    <div>
                                        <h1 class="title"> <?php echo get_the_title(); ?> </h1>
                                    </div>
                                </div>
                            </div>
                            </div>
                    </div>
                <?php endwhile; ?>
            </div>

            <script type="text/javascript">
                document.addEventListener('DOMContentLoaded', function () {
                    var listItems = document.querySelectorAll('#category-filter-list a');
                    listItems.forEach(function (item) {
                        item.addEventListener('click', function (event) {
                            // No need to prevent default here; the link's href handles the filtering
                        });
                    });
                });
            </script>




            <?php if ($testimonials_query->max_num_pages > 1): ?>
                <div class="pagination-center text-center mt-md-5 mt-3 mb-3">
                    <div class="pagination-style-one">
                        <?php
                        echo paginate_links(array(
                            'total' => $testimonials_query->max_num_pages,
                            'current' => max(1, get_query_var('paged')),
                            'format' => '?paged=%#%',
                            'show_all' => false,
                            'type' => 'plain',
                            'prev_text' => '<i class="eicon-arrow-left"></i>',
                            'next_text' => '<i class="eicon-arrow-right"></i>',
                            'end_size' => 2,
                            'mid_size' => 2
                        ));
                        ?>
                    </div>
                </div>
            <?php endif; ?>


        <?php else:
        echo 'No testimonials found.';
    endif;

    wp_reset_postdata();

    return ob_get_clean();
}
add_shortcode('testimonials', 'display_testimonials');


// testimonials list end------------



// gallery strat ----------
function display_gallery($atts)
{
    // Attributes
    $atts = shortcode_atts(
        array(
            'posts_per_page' => 9,
            'category' => isset($_GET['category']) ? sanitize_text_field($_GET['category']) : '',
        ),
        $atts,
        'gallery'
    );


    $args = array(
        'post_type' => 'gallery',
        'posts_per_page' => $atts['posts_per_page'],
        'paged' => get_query_var('paged') ? get_query_var('paged') : 1,
        'post__not_in' => $featured_post_id ? array($featured_post_id) : array(),
    );


    if (!empty($atts['category'])) {
        $args['tax_query'] = array(
            array(
                'taxonomy' => 'gallery-category',
                'field' => 'slug',
                'terms' => $atts['category'],
            ),
        );
    }
    // Get categories
    $categories = get_terms(array(
        'taxonomy' => 'gallery-category',
        'hide_empty' => true,
        'orderby' => 'date',
        'order' => 'DESC',
    ));

    if ($categories):
        ?>
            <div class="col-lg-12 mb-5 text-center">
                <ul id="category-filter-list" class="document-filter nav justify-content-center">

                    <li><a href="<?php echo esc_url(add_query_arg('category', '', home_url('/gallery'))); ?>"
                            class="all-cat-head <?php echo empty($atts['category']) ? 'active' : ''; ?>"> All </a></li>
                    <?php foreach ($categories as $category):
                        $active_class = ($atts['category'] === $category->slug) ? 'active' : '';
                        ?>
                        <li>
                            <a href="<?php echo esc_url(add_query_arg('category', $category->slug, home_url('/gallery'))); ?>"
                                class="cats <?php echo esc_attr($active_class); ?>">
                                <?php echo esc_html($category->name); ?>
                            </a>
                        </li>
                    <?php endforeach; ?>
                </ul>
            </div>
            <?php
    endif;




    $gallery_query = new WP_Query($args);

    ob_start();

    if ($gallery_query->have_posts()): ?>
            <div class="gallery-wrap">
                <div class="row gy-3 mx-0">

        
                    <?php while ($gallery_query->have_posts()):
                        $gallery_query->the_post();

                        ?>

                        <div class="col-lg-4 col-md-4 col-sm-6">
                            <div class="event-box">
                                <?php
                                $featured_video = get_field('featured_video'); // Get the featured video field.
                                ?>
                                <?php
                                if ($featured_video) {
                                    $file_url = is_array($featured_video) ? $featured_video['url'] : $featured_video; ?>
                                      <a href="#"  data-bs-toggle="modal"
                                            data-bs-target="#videoModal<?php echo get_the_ID(); ?>">
                                    <div class="videos-box mb-3">
                                        <video controls width="100%">
                                            <source src="<?php echo esc_url($file_url); ?>" type="video/mp4" class="video-box">
                                        </video>
                                        <img src="https://draftsite1.com/yap-lee-motor/wp-content/uploads/2025/08/Play-Button.png" class="play-btn" alt="">
                                    </div>
                                    </a>
                                    
                             <?php   } elseif (has_post_thumbnail()) {?>
                                     <a href="#"  data-bs-toggle="modal"
                                            data-bs-target="#videoModal<?php echo get_the_ID(); ?>"> <div class="img-box mb-3">
                                 <?php   the_post_thumbnail('full', array('class' => 'w-100 main-img mb-3')); ?>
                                    </div></a>
                             <?php   }
                                ?>
                            
                            </div>
                        </div>

                    <?php endwhile; ?>
                </div>

                <?php while ($gallery_query->have_posts()):
                    $gallery_query->the_post();

                    ?>

                    <!-- Video Modal -->
                    <div class="modal  gallery-model" id="videoModal<?php echo get_the_ID(); ?>">
                        <small class="btn-close btn-close-white border-0" type="button" data-bs-dismiss="modal"></small>
                        <div class="modal-dialog modal-dialog-centered modal-lg">

                            <div class="modal-content bg-transparent border-0 rounded-0">\
                                <div class="modal-body">

                                    <?php
                                    $featured_video = get_field('featured_video'); // Get the featured video field.
                                    ?>
                                    <?php
                                    if ($featured_video) {
                                        $file_url = is_array($featured_video) ? $featured_video['url'] : $featured_video;
                                        echo '<div class="mb-3">
                                        <video controls autoplay muted width="100%">
                                            <source src="' . esc_url($file_url) . '" type="video/mp4" class="video-box">
                                        </video>
                                    </div>';
                                    }  elseif (has_post_thumbnail()) {?>
                                        <div class="img-box mb-0">
                                    <?php   the_post_thumbnail('full', array('class' => 'w-100 main-img mb-3')); ?>
                                       </div>
                                <?php   }
                                   ?>
                                </div>
                            </div>
                        </div>
                    </div>

                <?php endwhile; ?>

            </div>


            <script type="text/javascript">
                document.addEventListener('DOMContentLoaded', function () {
                    var listItems = document.querySelectorAll('#category-filter-list a');
                    listItems.forEach(function (item) {
                        item.addEventListener('click', function (event) {
                            // No need to prevent default here; the link's href handles the filtering
                        });
                    });
                });
            </script>
  <?php if ($gallery_query->max_num_pages > 1): ?>
            <div class="pagination-center text-center mt-md-5 mt-3 mb-3">
                <div class="pagination-style-one">
                    <?php
                    echo paginate_links(
                        array(
                            'total' => $gallery_query->max_num_pages,
                            'current' => max(1, get_query_var('paged')),
                            'format' => '?paged=%#%',
                            'show_all' => false,
                            'type' => 'plain',
                            'prev_text' => '<i class="eicon-arrow-left"></i>',
                            'next_text' => '<i class="eicon-arrow-right"></i>',
                            'end_size' => 2,
                            'mid_size' => 2
                        )
                    );
                    ?>
                </div>
            </div>
            <?php endif; ?>

        <?php else:
        echo 'No gallery found.';
    endif;

    wp_reset_postdata();

    return ob_get_clean();
}
add_shortcode('gallery', 'display_gallery');


// gallery page end ------------------------------------------------------------



// blog related start --------------------

function get_related_articles($post_id, $number_of_posts = 5)
{

    $args = array(
        'post_type' => 'post',
        'post__not_in' => array($post_id),
        'posts_per_page' => $number_of_posts,
        'ignore_sticky_posts' => 1,
        'orderby' => 'date',
        'order' => 'DESC',
    );

    return get_posts($args);

    $related_posts = get_related_articles(get_the_ID());

    // If not enough related posts by category, get related posts by tag
    if (count($related_posts) < $number_of_posts) {
        $tags = wp_get_post_tags($post_id);
        if ($tags) {
            $tag_ids = array();
            foreach ($tags as $tag) {
                $tag_ids[] = $tag->term_id;
            }
            $args = array(
                'tag__in' => $tag_ids,
                'post__not_in' => array_merge(array($post_id), wp_list_pluck($related_posts, 'ID')),
                'posts_per_page' => $number_of_posts - count($related_posts),
                'ignore_sticky_posts' => 1,
            );
            $more_related_posts = get_posts($args);
            $related_posts = array_merge($related_posts, $more_related_posts);
        }
    }

    return $related_posts;
}

// blog related end --------------------




// woocommerce code start here ---------------------

// View Product Button ------------ 
add_action('woocommerce_before_shop_loop_item_title', 'custom_view_product_button', 20);
function custom_view_product_button()
{
    global $product;
    echo '<div class="custom-view-button">
            <div class="animated-btn">
                <a href="' . get_permalink($product->get_id()) . '" class="view-product-link">
                  <img src="https://draftsite1.com/yap-lee-motor/wp-content/uploads/2025/08/View-Product.svg">
                </a>
            </div>
          </div>';
}
// View Product Button end------------ 


//  WooCommerce product  image wrap  ----------
add_action('woocommerce_before_shop_loop_item_title', 'wrap_product_image_in_div', 5);
function wrap_product_image_in_div()
{
    echo '<div class="product-image-wrapper">';
}
add_action('woocommerce_before_shop_loop_item_title', 'close_product_image_div', 15);
function close_product_image_div()
{
    echo '</div>';
}
//  WooCommerce product image wrap ----------




remove_action( 'woocommerce_after_single_product_summary', 'woocommerce_output_related_products', 20 );

// Add back related products with custom title
add_action( 'woocommerce_after_single_product_summary', 'custom_output_related_products_with_custom_heading', 20 );

function custom_output_related_products_with_custom_heading() {
    global $product;

    $args = array(
        'posts_per_page' => 4,
        'columns'        => 4,
        'orderby'        => 'rand', // Or 'date', etc.
    );

    $subheading = '<span>Related Product</span>';

    $heading = 'YOU MAY ALSO LIKE';

    $related_products = wc_get_related_products( $product->get_id(), $args['posts_per_page'] );

    if ( count( $related_products ) === 0 ) {
        return;
    }

    echo '<section class="related products">';
    echo '<h2>' . $subheading . '</h2>';
    echo '<h1>' . $heading . '</h1>';

    woocommerce_product_loop_start();

    foreach ( $related_products as $related_product_id ) {
        $post_object = get_post( $related_product_id );
        setup_postdata( $GLOBALS['post'] =& $post_object );
        wc_get_template_part( 'content', 'product' );
    }

    woocommerce_product_loop_end();

    echo '</section>';

    wp_reset_postdata();
}





// product-categories start ----------------------------------------- 
function wpb_woocommerce_product_categories_accordion()
{
    // Get the current queried product category
    $queried_object = get_queried_object();
    $current_category_id = ($queried_object && isset($queried_object->term_id)) ? $queried_object->term_id : 0;

    // Get all parent categories of the current category
    $current_category_parents = [];
    if ($current_category_id) {
        $parent_categories = get_ancestors($current_category_id, 'product_cat');
        $current_category_parents = array_map('intval', $parent_categories);
    }

    // Recursive function to get subcategories with checkboxes
    function get_subcategories($parent_id, $level = 1, $current_category_id, $current_category_parents)
    {
        $args = array(
            'taxonomy' => 'product_cat',
            'orderby' => 'name',
            'order' => 'ASC',
            'parent' => $parent_id,
            'hide_empty' => true
        );
        $sub_categories = get_terms($args);

        if (!empty($sub_categories)) {
            echo '<ul class="list-unstyled ps-2">';
            foreach ($sub_categories as $sub_category) {
                $is_checked = ($sub_category->term_id == $current_category_id) ? 'checked' : '';
                $active_class = ($sub_category->term_id == $current_category_id) ? 'current-category' : '';

                echo '<li class="' . $active_class . '">';
                echo '<div class="in-menu">';
                echo '<input type="checkbox" class="category-checkbox me-2" data-category-id="' . $sub_category->term_id . '" ' . $is_checked . '> ';

                echo '<a href="' . get_term_link($sub_category) . '">  <span class="customcheck"></span>' . $sub_category->name . '</a>';
                echo '</div>';
                get_subcategories($sub_category->term_id, $level + 1, $current_category_id, $current_category_parents);
                echo '</li>';
            }
            echo '</ul>';
        }
    }

    // Get main product categories (parent categories)
    $args = array(
        'taxonomy' => 'product_cat',
        'orderby' => 'name',
        'order' => 'ASC',
        'parent' => 0,
        'hide_empty' => true
    );
    $product_categories = get_terms($args);

    if ($product_categories) {
        ob_start();
        ?>
                    <div class="accordion" id="productCategoriesAccordion">

                        <?php
                        $shop_page_url = wc_get_page_permalink('shop');
                        $is_shop_page = is_shop();
                        ?>

                        <!-- <div class="accordion-item">
                            <div class="accordion-header <?php // echo $is_shop_page ? 'current-category' : ''; ?>">
                                <label>
                                    <a href="<?php // echo esc_url($shop_page_url); ?>" class="main-category">
                                        All
                                    </a>
                                </label>
                            </div>
                        </div> -->


                        <?php
                        $i = 0;
                        foreach ($product_categories as $category) {
                            $i++;

                            // Check if the category has subcategories
                            $sub_args = array(
                                'taxonomy' => 'product_cat',
                                'parent' => $category->term_id,
                                'hide_empty' => true
                            );
                            $sub_categories = get_terms($sub_args);
                            $has_subcategories = !empty($sub_categories);

                            // Determine if this category should be expanded
                            $is_checked = ($category->term_id == $current_category_id) ? 'checked' : '';
                            $active_class = ($category->term_id == $current_category_id || in_array($category->term_id, $current_category_parents)) ? 'current-category' : '';
                            $show_collapse = ($category->term_id == $current_category_id || in_array($category->term_id, $current_category_parents)) ? 'show' : '';
                            ?>
                            <div class="accordion-item <?php echo $active_class; ?>">
                                <div class="accordion-header d-flex align-items-center" id="heading<?php echo $i; ?>">
                                    <label for="cat<?php echo $category->term_id; ?>">
                                        <input type="checkbox" class="category-checkbox me-2"
                                            id="cat<?php echo $category->term_id; ?>"
                                            data-category-id="<?php echo $category->term_id; ?>" <?php echo $is_checked; ?>>

                                        <a href="<?php echo get_term_link($category); ?>" class="main-category">
                                            <span class="customcheck"></span> <?php echo $category->name; ?>
                                        </a>
                                    </label>

                                    <?php if ($has_subcategories) { ?>
                                        <button
                                            class="accordion-button ms-auto <?php echo ($show_collapse == '') ? 'collapsed' : ''; ?>"
                                            type="button" data-bs-toggle="collapse" data-bs-target="#collapse<?php echo $i; ?>"
                                            aria-expanded="<?php echo ($show_collapse) ? 'true' : 'false'; ?>"
                                            aria-controls="collapse<?php echo $i; ?>"
                                            data-category-id="<?php echo $category->term_id; ?>">
                                            <i class="fa fa-angle-down"></i>
                                        </button>
                                    <?php } ?>
                                </div>
                                <?php if ($has_subcategories) { ?>
                                    <div id="collapse<?php echo $i; ?>"
                                        class="accordion-collapse collapse <?php echo $show_collapse; ?>"
                                        aria-labelledby="heading<?php echo $i; ?>" data-bs-parent="#productCategoriesAccordion">
                                        <div class="accordion-body ps-0 pe-0">
                                            <?php get_subcategories($category->term_id, 1, $current_category_id, $current_category_parents); ?>
                                        </div>
                                    </div>
                                <?php } ?>
                            </div>
                            <?php
                        }
                        ?>
                    </div>

                    <script>
                        document.addEventListener("DOMContentLoaded", function () {
                            var savedCategories = JSON.parse(localStorage.getItem("checkedCategories")) || [];

                            savedCategories.forEach(function (categoryId) {
                                var checkbox = document.querySelector('.category-checkbox[data-category-id="' + categoryId + '"]');
                                if (checkbox) {
                                    checkbox.checked = true;
                                }
                            });

                            document.querySelectorAll(".category-checkbox").forEach(function (checkbox) {
                                checkbox.addEventListener("change", function () {
                                    var categoryId = this.getAttribute("data-category-id");
                                    if (this.checked) {
                                        if (!savedCategories.includes(categoryId)) {
                                            savedCategories.push(categoryId);
                                        }
                                    } else {
                                        savedCategories = savedCategories.filter(id => id !== categoryId);
                                    }
                                    localStorage.setItem("checkedCategories", JSON.stringify(savedCategories));
                                });
                            });

                            var activeCategory = localStorage.getItem("activeCategory");
                            if (activeCategory) {
                                var activeAccordion = document.querySelector('[data-category-id="' + activeCategory + '"]');
                                if (activeAccordion) {
                                    var collapseElement = activeAccordion.getAttribute("data-bs-target");
                                    document.querySelector(collapseElement).classList.add("show");
                                    activeAccordion.classList.remove("collapsed");
                                    activeAccordion.setAttribute("aria-expanded", "true");
                                }
                            }

                            document.querySelectorAll(".accordion-button").forEach(function (button) {
                                button.addEventListener("click", function () {
                                    var categoryId = this.getAttribute("data-category-id");
                                    if (document.querySelector(this.getAttribute("data-bs-target")).classList.contains("show")) {
                                        localStorage.removeItem("activeCategory");
                                    } else {
                                        localStorage.setItem("activeCategory", categoryId);
                                    }
                                });
                            });
                        });
                    </script>

                    <style>
                        .current-category>a {
                            font-weight: bold;
                            color: #ff6600;
                        }

                        .category-checkbox {
                            display: none;
                        }

                        span.customcheck {
                            background: #FFFFFF 0% 0% no-repeat padding-box;
                            border: 1px solid #B7DBEE;
                            border-radius: 5px;
                            width: 15px;
                            height: 15px;
                            position: relative;
                            margin-right: 6px;
                            margin-top: 0px;
                            top: 2px;
                            display: none;
                        }

                        .current-category [type=checkbox]:checked~a span.customcheck {
                            background: #326783;
                            border-color: #326783;
                        }

                        .current-category [type=checkbox]~a .customcheck:after {
                            content: "";
                            position: absolute;
                        }

                        .current-category a input:checked~.customcheck:after {
                            display: block;
                        }

                        .current-category a .customcheck:after {
                            left: 5px;
                            top: 2px;
                            width: 4px;
                            height: 8px;
                            border: solid white;
                            border-width: 0 2px 2px 0;
                            -webkit-transform: rotate(45deg);
                            -ms-transform: rotate(45deg);
                            transform: rotate(45deg);
                        }
                    </style>
                    <?php
                    return ob_get_clean();
    }
}

add_shortcode('product_categories_accordion', 'wpb_woocommerce_product_categories_accordion');

// product category for sidebar end -------------------------------





// brand filter -------------------
function brand_checkbox_filter_shortcode() {
    $terms = get_terms(array(
        'taxonomy' => 'product_brand',
        'hide_empty' => true,
    ));

    if (empty($terms) || is_wp_error($terms)) {
        return '<p>No brands available.</p>';
    }

    $selected = isset($_GET['product_brand']) ? (array) $_GET['product_brand'] : [];

    ob_start();
    ?>
    <form method="GET" id="brand-filter-form" class="brand-filter-form">
        <div class="brand-filter-checkboxes">
            <?php foreach ($terms as $term): ?>
                <label>
                    
                   <p class="mb-0 d-inline">  <?php echo esc_html($term->name); ?> </p> 
                    <input type="checkbox" name="product_brand[]" value="<?php echo esc_attr($term->slug); ?>"
                        <?php checked(in_array($term->slug, $selected)); ?>
                        onchange="this.form.submit()">
                        <span class="customcheckbox"> </span>
                </label>
            <?php endforeach; ?>
        </div>
    </form>
    <?php
    return ob_get_clean();
}
add_shortcode('brand_checkbox_filter', 'brand_checkbox_filter_shortcode');

function apply_brand_checkbox_filter_to_products($query) {
    if (!is_admin() && $query->is_main_query() && is_post_type_archive('product')) {
        if (!empty($_GET['product_brand']) && is_array($_GET['product_brand'])) {
            $brands = array_map('sanitize_text_field', $_GET['product_brand']);

            $query->set('tax_query', array(array(
                'taxonomy' => 'product_brand',
                'field'    => 'slug',
                'terms'    => $brands,
                'operator' => 'IN',
            )));
        }
    }
}
add_action('pre_get_posts', 'apply_brand_checkbox_filter_to_products');
// brand filter end -------------------




// single shop banner  start ---------------------------
// Remove default breadcrumb location
remove_action('woocommerce_before_main_content', 'woocommerce_breadcrumb', 20);

// Add breadcrumb before product title
add_action('woocommerce_single_product_summary', 'woocommerce_breadcrumb', 4);



// Move short description before price
function move_short_description_before_price() {
    // Pehle default short description remove karo
    remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_excerpt', 20 );
    // Fir price se pehle add karo (price priority 10 hai, to hum 9 use karenge)
    add_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_excerpt', 9 );
}
add_action( 'woocommerce_before_single_product', 'move_short_description_before_price' );





// wpgis  product gallery ------------------
add_action('wp_footer', 'hide_gallery_thumbs_if_single_image');
function hide_gallery_thumbs_if_single_image()
{
    if (is_product()): ?>
                    <script>
                        jQuery(document).ready(function ($) {
                            $(window).on('load', function () {
                                var thumbCount = $('.wpgis-slider-nav .slick-slide').length;

                                if (thumbCount <= 1) {
                                    $('.wpgis-slider-nav').hide();
                                    $('.wpgis-slider-for').addClass('full-width-slider');
                                } else {
                                    $('.wpgis-slider-nav').show();
                                    $('.wpgis-slider-for').removeClass('full-width-slider');
                                }
                            });
                        });
                    </script>
                <?php endif;
}
// wpgis  product gallery end ------------------








// validation start -----------------------------------------------------------



// validation woocommerce start 


add_action('woocommerce_save_account_details_errors', 'validate_my_account_fields', 10, 1);

function validate_my_account_fields($errors)
{
    // Validate First Name
    if (isset($_POST['account_first_name']) && !preg_match('/^[a-zA-Z\s]+$/', $_POST['account_first_name'])) {
        $errors->add('validation', __('Allowed characters for First Name are alphabets and spaces only.', 'woocommerce'));
    }

    // Validate Last Name
    if (isset($_POST['account_last_name']) && !preg_match('/^[a-zA-Z\s]+$/', $_POST['account_last_name'])) {
        $errors->add('validation', __('Allowed characters for Last Name are alphabets and spaces only.', 'woocommerce'));
    }

    // Validate Display Name
    if (isset($_POST['account_display_name']) && !preg_match('/^[a-zA-Z\s]+$/', $_POST['account_display_name'])) {
        $errors->add('validation', __('Allowed characters for Display Name are alphabets and spaces only.', 'woocommerce'));
    }
}




add_action('woocommerce_after_save_address_validation', 'validate_billing_address_fields', 10, 2);

function validate_billing_address_fields($user_id, $address_type)
{
    if ('billing' === $address_type) {
        // Initialize an array to store error messages
        $validation_errors = [];

        // Get the values of the fields from the form
        $billing_first_name = isset($_POST['billing_first_name']) ? sanitize_text_field($_POST['billing_first_name']) : '';
        $billing_last_name = isset($_POST['billing_last_name']) ? sanitize_text_field($_POST['billing_last_name']) : '';
        $billing_city = isset($_POST['billing_city']) ? sanitize_text_field($_POST['billing_city']) : '';
        $billing_address_1 = isset($_POST['billing_address_1']) ? sanitize_text_field($_POST['billing_address_1']) : '';

        $billing_postcode = isset($_POST['billing_postcode']) ? sanitize_text_field($_POST['billing_postcode']) : '';
        $billing_email = isset($_POST['billing_email']) ? sanitize_email($_POST['billing_email']) : '';

        // Validate Billing First Name (Only alphabets and spaces allowed)
        if (!preg_match('/^[a-zA-Z\s]+$/', $billing_first_name)) {
            $validation_errors[] = __('Allowed characters for Billing First Name are alphabets and spaces only.', 'woocommerce');
        }

        // Validate Billing Last Name (Only alphabets and spaces allowed)
        if (!preg_match('/^[a-zA-Z\s]+$/', $billing_last_name)) {
            $validation_errors[] = __('Allowed characters for Billing Last Name are alphabets and spaces only.', 'woocommerce');
        }

        // Validate Billing Last Name (Only alphabets and spaces allowed)
        if (!preg_match('/^[a-zA-Z\s]+$/', $billing_city)) {
            $validation_errors[] = __('Allowed characters for Billing City Name are alphabets and spaces only.', 'woocommerce');
        }

        // Validate Address (Only letters, numbers, and spaces)
        if (!preg_match('/^[a-zA-Z0-9\s]+$/', $billing_address_1)) {
            $validation_errors[] = __('Address must contain only letters, numbers, and spaces.', 'woocommerce');
        }

        // Validate Postcode (Only numbers, 4-10 digits)
        if (!preg_match('/^\d{4,6}$/', $billing_postcode)) {
            $validation_errors[] =  __('Postcode must be a number between 4 and 6 digits.', 'woocommerce');
        }



        // Validate Billing Email (Basic Email validation)
        if (!is_email($billing_email)) {
            $validation_errors[] = __('Please enter a valid email address.', 'woocommerce');
        }

        // If there are validation errors, stop the form submission and display the errors
        if (!empty($validation_errors)) {
            // Add all validation errors as WooCommerce notices
            foreach ($validation_errors as $error_message) {
                wc_add_notice($error_message, 'error');  // Add error messages
            }

            // Stop the form submission by returning early
            return; // This will prevent the address from being saved
        }
    }
}








add_action('woocommerce_after_save_address_validation', 'validate_shipping_address_fields', 10, 2);

function validate_shipping_address_fields($user_id, $address_type)
{
    if ('shipping' === $address_type) {
        // Initialize an array to store error messages
        $validation_errors = [];

        // Get the values of the fields from the form
        $shipping_first_name = isset($_POST['shipping_first_name']) ? sanitize_text_field($_POST['shipping_first_name']) : '';
        $shipping_last_name = isset($_POST['shipping_last_name']) ? sanitize_text_field($_POST['shipping_last_name']) : '';
        $shipping_city = isset($_POST['shipping_city']) ? sanitize_text_field($_POST['shipping_city']) : '';
        $shipping_address_1 = isset($_POST['shipping_address_1']) ? sanitize_text_field($_POST['shipping_address_1']) : '';

        $shipping_postcode = isset($_POST['shipping_postcode']) ? sanitize_text_field($_POST['shipping_postcode']) : '';
      //  $shipping_email = isset($_POST['shipping_email']) ? sanitize_email($_POST['shipping_email']) : '';

        // Validate shipping First Name (Only alphabets and spaces allowed)
        if (!preg_match('/^[a-zA-Z\s]+$/', $shipping_first_name)) {
            $validation_errors[] = __('Allowed characters for shipping First Name are alphabets and spaces only.', 'woocommerce');
        }

        // Validate shipping Last Name (Only alphabets and spaces allowed)
        if (!preg_match('/^[a-zA-Z\s]+$/', $shipping_last_name)) {
            $validation_errors[] = __('Allowed characters for shipping Last Name are alphabets and spaces only.', 'woocommerce');
        }

        // Validate shipping Last Name (Only alphabets and spaces allowed)
        if (!preg_match('/^[a-zA-Z\s]+$/', $shipping_city)) {
            $validation_errors[] = __('Allowed characters for shipping City Name are alphabets and spaces only.', 'woocommerce');
        }

        // Validate Address (Only letters, numbers, and spaces)
        if (!preg_match('/^[a-zA-Z0-9\s]+$/', $shipping_address_1)) {
            $validation_errors[] = __('Address must contain only letters, numbers, and spaces.', 'woocommerce');
        }

        // Validate Postcode (Only numbers, 4-10 digits)
        if (!preg_match('/^\d{4,6}$/', $shipping_postcode)) {
            $validation_errors[] =  __('Postcode must be a number between 4 and 6 digits.', 'woocommerce');
        }



        // Validate shipping Email (Basic Email validation)
        // if (!is_email($shipping_email)) {
        //     $validation_errors[] = __('Please enter a valid email address.', 'woocommerce');
        // }

        // If there are validation errors, stop the form submission and display the errors
        if (!empty($validation_errors)) {
            // Add all validation errors as WooCommerce notices
            foreach ($validation_errors as $error_message) {
                wc_add_notice($error_message, 'error');  // Add error messages
            }

            // Stop the form submission by returning early
            return; // This will prevent the address from being saved
        }
    }
}




// validation woocommerce end --------------------







// contact form validation 

// Validate text fields (only alphabets allowed)
add_filter( 'wpcf7_validate_text', 'alpha_validation_filter_text', 20, 2 );
add_filter( 'wpcf7_validate_text*', 'alpha_validation_filter_text', 20, 2 );

function alpha_validation_filter_text( $result, $tag ) {
    if ( class_exists( 'WPCF7_FormTag' ) ) {
        $tag = new WPCF7_FormTag( $tag ); // Corrected class
    }

    if ( 'names' === $tag->name ) {
        $name_of_the_input = isset( $_POST[$tag->name] ) ? trim( $_POST[$tag->name] ) : '';

        if ( ! preg_match('/^[a-zA-Z\s]+$/', $name_of_the_input) ) {
            $result->invalidate( $tag, "Allowed characters are Alphabets only." );
        }
    }

    if ( 'lname' === $tag->name ) {
        $name_of_the_input = isset( $_POST[$tag->name] ) ? trim( $_POST[$tag->name] ) : '';

        if ( ! preg_match('/^[a-zA-Z\s]+$/', $name_of_the_input) ) {
            $result->invalidate( $tag, "Allowed characters are Alphabets only." );
        }
    }

    return $result;
}

// Validate phone number (must be exactly 10 digits)
add_filter( 'wpcf7_validate_tel', 'numeric_phone_validation_filter', 20, 2 );
add_filter( 'wpcf7_validate_tel*', 'numeric_phone_validation_filter', 20, 2 );

function numeric_phone_validation_filter( $result, $tag ) {
    if ( class_exists( 'WPCF7_FormTag' ) ) {
        $tag = new WPCF7_FormTag( $tag ); // Corrected class
    }

    if ( 'phone' === $tag->name ) {
        $phone_number = isset( $_POST[$tag->name] ) ? trim( $_POST[$tag->name] ) : '';

        if ( ! preg_match( '/^\d{8}$/', $phone_number ) ) {
            $result->invalidate( $tag, "Phone number must contain exactly 8 digits." );
        }
    }

    return $result;
}



// Validate email (must be a valid email format)
add_filter( 'wpcf7_validate_email', 'validate_email_filter', 20, 2 );
add_filter( 'wpcf7_validate_email*', 'validate_email_filter', 20, 2 );

function validate_email_filter( $result, $tag ) {
    if ( class_exists( 'WPCF7_FormTag' ) ) {
        $tag = new WPCF7_FormTag( $tag ); // Corrected class
    }

    if ( 'email' === $tag->name ) {
        $email = isset( $_POST[$tag->name] ) ? trim( $_POST[$tag->name] ) : '';

        if ( ! filter_var( $email, FILTER_VALIDATE_EMAIL ) ) {
            $result->invalidate( $tag, "Please enter a valid email address." );
        }
    }

    return $result;
}


// Validate textarea field (message)
add_filter( 'wpcf7_validate_textarea', 'validate_textarea_filter', 20, 2 );
add_filter( 'wpcf7_validate_textarea*', 'validate_textarea_filter', 20, 2 );

function validate_textarea_filter( $result, $tag ) {
    if ( class_exists( 'WPCF7_FormTag' ) ) {
        $tag = new WPCF7_FormTag( $tag ); // Corrected class
    }

    if ( 'message' === $tag->name ) {
        $message = isset( $_POST[$tag->name] ) ? trim( $_POST[$tag->name] ) : '';

        // Allowed characters: alphabets, spaces, common punctuation marks
        if ( ! preg_match( '/^[a-zA-Z0-9\s.,!?()-]+$/', $message ) ) {
            $result->invalidate( $tag, "Message contains invalid characters. Only letters, numbers, spaces, and punctuation are allowed." );
        }

        // Min 10 characters, Max 500 characters
        if ( strlen( $message ) < 10 || strlen( $message ) > 500 ) {
            $result->invalidate( $tag, "Message must be between 10 and 500 characters." );
        }
    }

    return $result;
}




// validation end -----------------------------------------------------------